package com.xforceplus.tech.base.core.dispatcher.process.impl;

import com.xforceplus.tech.base.BaseComponentRegistry;
import com.xforceplus.tech.base.core.dispatcher.process.ProcessStageExecutor;
import com.xforceplus.tech.base.scene.Scene;
import com.xforceplus.tech.business.converter.Converter;

import java.util.List;
import java.util.Optional;

public abstract class ProcessStageExecutorSupport implements ProcessStageExecutor {

    private final BaseComponentRegistry registry;

    public ProcessStageExecutorSupport(BaseComponentRegistry registry) {
        this.registry = registry;
    }

    protected BaseComponentRegistry getRegistry() {
        return this.registry;
    }

    protected <T> T getNextValidInput(Object lastOutput, Class<T> targetClass, List<Scene> scenes) {
        if (targetClass.isAssignableFrom(lastOutput.getClass())) {
            return (T) lastOutput;
        } else {
            Optional<Converter> implicityConverter = findImplicityConverter(lastOutput, targetClass, scenes);
            if (implicityConverter.isPresent()) {
                Converter converter = implicityConverter.get();
                Object convert = converter.convert(lastOutput);
                if (targetClass.isAssignableFrom(convert.getClass())) {
                    return (T) lastOutput;
                } else {
                    throw new RuntimeException("Fatal error converter is not error");
                }
            } else {
                throw new RuntimeException("No convert found");
            }
        }
    }

    /**
     * TODO
     * @param object
     * @param targetClass
     * @param scenes
     * @return
     */
    protected Optional<Converter> findImplicityConverter(Object object, Class targetClass, List<Scene> scenes) {
        List<Converter> converters = registry.findByKindAndScenes(Converter.class, scenes);
        Optional<Converter> converterOp = converters.stream().filter(c -> c.support(object.getClass(), targetClass)).findFirst();
        return converterOp;
    }
}
