package com.xforceplus.tech.base.core.dispatcher.process.impl;

import com.xforceplus.tech.base.BaseComponentRegistry;
import com.xforceplus.tech.base.scene.Scene;
import com.xforceplus.tech.business.middleware.Middleware;
import com.xforceplus.tech.business.processflow.dsl.ProcessContext;
import com.xforceplus.tech.business.processflow.dsl.ProcessStage;
import com.xforceplus.tech.business.processflow.dsl.pred.SideEffectStage;

import java.util.List;

/**
 * side effectProcessStageExecutor
 */
public class SideEffectProcessStageExecutor extends ProcessStageExecutorSupport {

    public SideEffectProcessStageExecutor(BaseComponentRegistry registry) {
        super(registry);
    }

    @Override
    public boolean required(ProcessStage processStage) {
        return processStage instanceof SideEffectStage;
    }

    @Override
    public Object doProcess(ProcessStage processStage, ProcessContext processContext) {
        SideEffectStage sideEffectStage = (SideEffectStage) processStage;
        Class<Middleware> middlewareClass = sideEffectStage.wrapperClass();
        List<Scene> currentScenes = processContext.getCurrentScenes();
        Object lastOutput = processContext.getLastOutput();
        if(lastOutput == null) {
            return lastOutput;
        }
        String name = sideEffectStage.name();
        Middleware middleware = getRegistry().findByKindAndNameWithScenes(name, middlewareClass, currentScenes);
        if(middleware != null ) {
            Class sourceType = middleware.getSourceType();
            Object nextValidInput = getNextValidInput(lastOutput, sourceType, currentScenes);
            Object output = middleware.map(processContext).apply(nextValidInput);
            return output;
        } else {
            //TODO
            throw new RuntimeException("Middleware " + name  + "is missing");
        }
    }
}
