package com.xforceplus.tech.base.core.dispatcher.process.impl;

import com.xforceplus.tech.base.BaseComponent;
import com.xforceplus.tech.base.BaseComponentRegistry;
import com.xforceplus.tech.base.scene.Scene;
import com.xforceplus.tech.business.converter.Converter;
import com.xforceplus.tech.business.processflow.dsl.ProcessContext;
import com.xforceplus.tech.business.processflow.dsl.ProcessStage;
import com.xforceplus.tech.business.processflow.dsl.pred.TransformerStage;
import com.xforceplus.tech.business.validator.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * Transformer
 */
public class TransformerProcessStageExecutor extends ProcessStageExecutorSupport {

    private Logger log = LoggerFactory.getLogger(TransformerProcessStageExecutor.class);

    public TransformerProcessStageExecutor(BaseComponentRegistry registry) {
        super(registry);
    }

    @Override
    public boolean required(ProcessStage processStage) {
        return processStage instanceof TransformerStage;
    }

    @Override
    public Object doProcess(ProcessStage processStage, ProcessContext processContext) {
        TransformerStage transformerStage = (TransformerStage) processStage;

        Object lastOutput = processContext.getLastOutput();
        String name = transformerStage.name();
        Class transformerClass = transformerStage.wrapperClass();
        List<Scene> currentScenes = processContext.getCurrentScenes();

        if(lastOutput == null) {
            log.warn("last output is null");
            return null;
        }

        /**
         * current is only converter
         */
        if(Converter.class.isAssignableFrom(transformerClass)) {
            Converter converter  = (Converter) getRegistry().findByKindAndNameWithScenes(name, transformerClass, currentScenes);
            if(converter != null) {
                //no other converter?
                boolean supportCurrent = converter.support(lastOutput.getClass(), Object.class);
                if(supportCurrent) {
                    Object convert = converter.convert(lastOutput);
                    return convert;
                } else {
                    throw new RuntimeException("CurrentConverter is not support " + lastOutput.getClass());
                }
            } else {
                //TODO
                throw new RuntimeException("Converter is missing");
            }
        } else {
            throw new RuntimeException("Transformer current is only support convertor");
        }
    }
}
