package com.xforceplus.tech.base.core.dispatcher.process.impl;

import com.xforceplus.tech.base.BaseComponentRegistry;
import com.xforceplus.tech.base.scene.Scene;
import com.xforceplus.tech.business.exception.ValidationException;
import com.xforceplus.tech.business.processflow.dsl.ProcessContext;
import com.xforceplus.tech.business.processflow.dsl.ProcessStage;
import com.xforceplus.tech.business.processflow.dsl.pred.ValidateStage;
import com.xforceplus.tech.business.validator.Validator;
import com.xforceplus.tech.business.validator.XValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

public class ValidationProcessStageExecutor extends ProcessStageExecutorSupport {

    private Logger log = LoggerFactory.getLogger(ValidationProcessStageExecutor.class);

    public ValidationProcessStageExecutor(BaseComponentRegistry registry) {
        super(registry);
    }

    @Override
    public boolean required(ProcessStage processStage) {
        return processStage instanceof ValidateStage;
    }

    @Override
    public Object doProcess(ProcessStage processStage, ProcessContext processContext) {

        ValidateStage validateStage = (ValidateStage) processStage;
        Object lastOutput = processContext.getLastOutput();

        Class<Validator> validatorClass = validateStage.wrapperClass();
        String name = validateStage.name();
        List<Scene> currentScenes = processContext.getCurrentScenes();
        //name should not null
        Validator validator = getRegistry().findByKindAndNameWithScenes(name, validatorClass, currentScenes);
        if (validator != null) {

            if (lastOutput == null ) {
                if(validator.checkNull()) {
                    throw new RuntimeException("Input cannot be null");
                } else {
                    return null;
                }
            }

            Class validClass = validator.validClass();
            Object nextValidInput = getNextValidInput(lastOutput, validClass, currentScenes);
            if (nextValidInput == null) {
                throw new RuntimeException("Cannot get valid object to validate");
            } else {
                /**
                 * throw exception validation ?
                 */
                XValidation validation = validator.validate(nextValidInput);
                if (validation.isInvalid()) {
                    throw new ValidationException(validation);
                } else {
                    //TODO context?
                    return lastOutput;
                }
            }
        } else {
            log.warn("Validator cannot found {}, skip", name);
        }

        return lastOutput;
    }
}
