package com.xforceplus.tech.base.core.security.tenant.adapater;

import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.core.security.tenant.TenantUserKey;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.token.domain.TokenRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Tenant adapter
 */
public class TenantAdapter extends HandlerInterceptorAdapter {

    private final ContextService contextService;

    private Logger logger = LoggerFactory.getLogger(TenantAdapter.class);

    public TenantAdapter(ContextService contextService) {
        this.contextService = contextService;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            IAuthorizedUser user = UserInfoHolder.get();
            if (user != null) {
                contextService.getAll().put("user", user);
                contextService.set(ContextKeys.StringKeys.TENANTID_KEY, String.valueOf(user.getTenantId()));
                contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, user.getTenantCode());
                contextService.set(ContextKeys.StringKeys.USERNAME, user.getUserCode());
//            contextService.set(ContextKeys.StringKeys.USER_LOGINNAME, user.getLoginName());
                contextService.set(ContextKeys.StringKeys.USER_DISPLAYNAME, user.getUserName());
                contextService.set(ContextKeys.LongKeys.ID, user.getId());
                contextService.set(ContextKeys.LongKeys.ACCOUNT_ID, user.getAccountId());
                contextService.set(TenantUserKey.TENANT_USER, user);
                contextService.set(ContextKeys.LongKeys.TENANT_ID, user.getTenantId());

                /**
                 * user.getRoles current is null;
                 */
                Set<TokenRole> roles = user.getRoles();

                List<Long> ids = roles.stream().map(TokenRole::getId).collect(Collectors.toList());
                List<String> codes = roles.stream().map(TokenRole::getCode).collect(Collectors.toList());
                contextService.set(ContextKeys.CollectionKeys.ROLE_CODES, codes);
                contextService.set(ContextKeys.CollectionKeys.ROLE_IDS, ids);

            }
        } catch (Exception ex) {
            logger.warn("{}", ex);
        }

        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        contextService.clear();
    }
}
