package com.xforceplus.tech.base.core.security.tenant.adapater;

import com.xforceplus.tech.base.anno.KV;
import com.xforceplus.tech.base.anno.OnScene;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.security.tenant.TenantUserKey;
import com.xforceplus.tech.base.scene.DynamicSceneProvider;
import com.xforceplus.tech.base.scene.Scene;
import com.xforceplus.tech.base.scene.pred.TenantScene;

import java.util.*;
import java.util.stream.Collectors;

/**
 * TODO
 * tenant related
 */
public class TenantSceneProvider implements DynamicSceneProvider {

    @Override
    public List<Scene> getSceneViaContext(Map<String, Object> context) {
        if(context.containsKey(ContextKeys.StringKeys.TENANTCODE_KEY.name())) {
            String tenantCode = (String) context.get(ContextKeys.StringKeys.TENANTCODE_KEY.name());
            TenantScene tenantScene = new TenantScene();
            tenantScene.setTenantCode(tenantCode);
            return Collections.singletonList(tenantScene);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Scene> filterScene(List<Scene> scenes) {
        return scenes.stream().filter(scene -> scene instanceof TenantScene).collect(Collectors.toList());
    }

    @Override
    public int matchScore(OnScene scenesOnTarget, List<Scene> scenes) {
        List<Scene> safeScenes = Optional.ofNullable(scenes).orElseGet(Collections::emptyList);
        if(safeScenes.isEmpty()) {
            return NOT_MATCHED;
        }

        KV[] scenesKV = scenesOnTarget.value();

        Optional<KV> tenantCode = Arrays.stream(scenesKV).filter(kv -> kv.k().equals("tenantCode")).findFirst();
        if(!tenantCode.isPresent()) {
            return NOT_MATCHED;
        } else {
            Optional<Scene> first = safeScenes.stream().filter(x -> x instanceof TenantScene)
                    .filter(x -> ((TenantScene) x).getTenantCode().equalsIgnoreCase(tenantCode.get().v())).findFirst();
            if(first.isPresent()) {
                return 10;
            } else {
                return NOT_MATCHED;
            }
        }
    }

    /**
     * TODO
     * @param scenesOnTarget
     * @param scenes
     * @return
     */
    @Override
    public int matchScore(Scene scenesOnTarget, List<Scene> scenes) {

        if(!(scenesOnTarget instanceof TenantScene)) {
            return 0;
        }

        List<Scene> safeScenes = Optional.ofNullable(scenes).orElseGet(Collections::emptyList);
        if(safeScenes.isEmpty()) {
            return NOT_MATCHED;
        }

        Optional<Scene> first = safeScenes.stream().filter(x -> x instanceof TenantScene)
                .filter(x -> ((TenantScene) x).getTenantCode().equalsIgnoreCase(((TenantScene) scenesOnTarget).getTenantCode())).findFirst();

        if(first.isPresent()) {
            return 10;
        } else {
            return NOT_MATCHED;
        }
    }
}
