package com.xforceplus.tech.base.core.security.tenant.autoconfiger;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.core.context.interceptor.ContextServiceInterceptor;
import com.xforceplus.tech.base.core.security.tenant.adapater.TenantAdapter;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnClass(UserInfoHolder.class)
@Order(Ordered.LOWEST_PRECEDENCE)
@AutoConfigureAfter(name = "TenantUserInterceptorConfig")
public class WebInterceptorConfigForAdapter implements WebMvcConfigurer {

    private static final Logger logger = LoggerFactory.getLogger(WebInterceptorConfigForAdapter.class);

    @Autowired
    ContextService contextService;

    public WebInterceptorConfigForAdapter() {
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        logger.info("registry interceptor:TenantAdapterInterceptor");
        registry
                .addWebRequestInterceptor(new ContextServiceInterceptor(contextService))
                .order(Ordered.HIGHEST_PRECEDENCE);
        registry
                .addInterceptor(new TenantAdapter(contextService))
                .order(Ordered.LOWEST_PRECEDENCE);
    }
}
