/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring;

import com.xforceplus.tech.base.BaseComponent;
import com.xforceplus.tech.base.BaseComponentRegistry;
import com.xforceplus.tech.base.RegistryAware;
import com.xforceplus.tech.base.trait.PreInitAware;
import com.xforceplus.tech.base.trait.PreInitConsumer;
import com.xforceplus.tech.metadata.spec.Metadata;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ComponentFactoryBean
extends AbstractFactoryBean<BaseComponent>
implements ApplicationContextAware {
    private Metadata metadata;
    private ApplicationContext applicationContext;
    private Class componentClass;
    private String name;
    @Autowired
    private List<PreInitConsumer> consumerList;
    private BaseComponentRegistry registry;

    public List<PreInitConsumer> getConsumerList() {
        return this.consumerList;
    }

    public void setConsumerList(List<PreInitConsumer> consumerList) {
        this.consumerList = consumerList;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class getComponentClass() {
        return this.componentClass;
    }

    public void setComponentClass(Class componentClass) {
        this.componentClass = componentClass;
    }

    public BaseComponentRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(BaseComponentRegistry registry) {
        this.registry = registry;
    }

    public Class<?> getObjectType() {
        return this.componentClass;
    }

    protected BaseComponent createInstance() throws Exception {
        BaseComponent componentObj = (BaseComponent)this.componentClass.newInstance();
        componentObj.name(this.name);
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)componentObj);
        if (componentObj instanceof RegistryAware) {
            ((RegistryAware)componentObj).setRegistry(this.registry);
        }
        if (componentObj instanceof PreInitAware) {
            Optional.ofNullable(this.consumerList).orElseGet(Collections::emptyList).forEach(x -> ((PreInitAware)componentObj).preInit(x));
        }
        componentObj.init(this.metadata);
        return componentObj;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

