/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring;

import com.xforceplus.tech.base.BaseComponent;
import com.xforceplus.tech.base.BaseComponentRegistry;
import com.xforceplus.tech.base.anno.OnScene;
import com.xforceplus.tech.base.anno.OnScenes;
import com.xforceplus.tech.base.pubsub.PubSub;
import com.xforceplus.tech.base.pubsub.dispatcher.NewMessageHandler;
import com.xforceplus.tech.base.pubsub.domain.SubscribeRequest;
import com.xforceplus.tech.base.scene.DynamicSceneProvider;
import com.xforceplus.tech.base.scene.Scene;
import com.xforceplus.tech.base.trait.PostInitAware;
import com.xforceplus.tech.base.trait.SceneAware;
import com.xforceplus.tech.metadata.spec.Metadata;
import com.xforceplus.tech.spring.ComponentFactoryBean;
import com.xforceplus.tech.spring.plugin.runtime.SceneMatcher;
import com.xforceplus.tech.spring.pubsub.PubSubRuntime;
import com.xforceplus.tech.spring.pubsub.TopicSubscription;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class SpringRegistry
implements BaseComponentRegistry,
ApplicationContextAware,
SmartInitializingSingleton,
BeanFactoryPostProcessor {
    private Logger log = LoggerFactory.getLogger(SpringRegistry.class);
    private ApplicationContext applicationContext;
    private BeanDefinitionRegistry registry;
    private ConfigurableListableBeanFactory beanFactory;
    private Map<String, List<ApplicationContext>> contextMapping = new ConcurrentHashMap<String, List<ApplicationContext>>();
    private Map<String, List<Tuple2<String, Object>>> cache = new ConcurrentHashMap<String, List<Tuple2<String, Object>>>();
    private final SceneMatcher sceneMatcher;

    public SpringRegistry(SceneMatcher sceneMatcher) {
        this.sceneMatcher = sceneMatcher;
    }

    public <T extends BaseComponent> T create(String name, Class<T> component, Metadata metadata) {
        return this.create(name, name, component, metadata);
    }

    public <T extends BaseComponent> T create(String uniqueName, String name, Class<T> component, Metadata metadata) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(ComponentFactoryBean.class);
        beanDefinition.setScope("singleton");
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        propertyValues.add("metadata", (Object)metadata);
        propertyValues.add("name", (Object)name);
        propertyValues.add("componentClass", component);
        propertyValues.add("registry", (Object)this);
        beanDefinition.setPropertyValues(propertyValues);
        beanDefinition.setAutowireCandidate(true);
        beanDefinition.setLazyInit(true);
        ((GenericApplicationContext)this.applicationContext).registerBeanDefinition(uniqueName, (BeanDefinition)beanDefinition);
        BaseComponent bean = (BaseComponent)this.applicationContext.getBean(uniqueName);
        if (((GenericApplicationContext)this.applicationContext).isRunning()) {
            this.doLifecycle(bean);
        }
        return (T)bean;
    }

    private void doLifecycle(BaseComponent bean) {
        if (bean instanceof PostInitAware) {
            ((PostInitAware)bean).doPost();
        }
        this.register(this.applicationContext.getId(), bean);
    }

    public void register(String token, BaseComponent baseComponent) {
        String name = baseComponent.name();
        this.cache.compute(name, (k, v) -> {
            if (v == null) {
                v = new LinkedList<Tuple2>();
            }
            v.add(Tuple.of((Object)token, (Object)baseComponent));
            return v;
        });
    }

    public void unRegister(String token) {
        this.cache.values().forEach(x -> x.removeIf(item -> ((String)item._1).equalsIgnoreCase(token)));
    }

    public <T extends BaseComponent> List<T> findByKind(Class<T> cls) {
        List list = this.cache.values().stream().flatMap(x -> x.stream()).filter(x -> cls.isAssignableFrom(x._2().getClass())).map(x -> (BaseComponent)x._2()).collect(Collectors.toList());
        return list;
    }

    public <T extends BaseComponent> List<T> findByKindAndScenes(Class<T> cls, List<Scene> scenes) {
        List list = this.cache.values().stream().flatMap(x -> x.stream()).filter(x -> cls.isAssignableFrom(x._2().getClass())).map(x -> (BaseComponent)x._2()).collect(Collectors.toList());
        ArrayList nonScene = new ArrayList();
        List sceneRelated = list.stream().filter(x -> {
            OnScenes onScenes = x.getClass().getAnnotation(OnScenes.class);
            if (onScenes != null) {
                Set annotation = AnnotatedElementUtils.getMergedRepeatableAnnotations(x.getClass(), OnScene.class);
                if (!annotation.isEmpty()) {
                    return this.sceneMatcher.isMatch(annotation.toArray(new OnScene[0]), scenes);
                }
                nonScene.add(x);
            } else {
                nonScene.add(x);
            }
            return false;
        }).collect(Collectors.toList());
        nonScene.addAll(sceneRelated);
        return nonScene;
    }

    public <T extends BaseComponent> T findByKindAndName(String name, Class<T> cls) {
        try {
            return (T)((BaseComponent)((GenericApplicationContext)this.applicationContext).getBeanFactory().getBean(name, cls));
        }
        catch (Exception ex) {
            this.log.warn(ex.getMessage());
            return null;
        }
    }

    public <T extends BaseComponent> T findByKindAndNameWithScenes(String name, Class<T> cls, List<Scene> scenes, Collection<DynamicSceneProvider> providers) {
        List list = Optional.ofNullable(this.cache.get(name)).orElseGet(Collections::emptyList).stream().filter(x -> cls.isAssignableFrom(x._2().getClass())).map(x -> (BaseComponent)x._2()).collect(Collectors.toList());
        ArrayList nonScene = new ArrayList();
        Optional<BaseComponent> first = list.stream().filter(x -> {
            if (x instanceof SceneAware) {
                List scenesFromComponentContent = (List)((SceneAware)x).scenes().apply(new ArrayList(providers));
                if (!scenesFromComponentContent.isEmpty()) {
                    return this.sceneMatcher.isMatch(scenesFromComponentContent, scenes);
                }
                nonScene.add(x);
            } else {
                nonScene.add(x);
            }
            return false;
        }).findFirst();
        if (first.isPresent()) {
            return (T)first.get();
        }
        if (!nonScene.isEmpty()) {
            return (T)((BaseComponent)nonScene.get(0));
        }
        return null;
    }

    public <T extends BaseComponent> T findByKindAndNameWithScenes(String name, Class<T> cls, List<Scene> scenes) {
        List list = Optional.ofNullable(this.cache.get(name)).orElseGet(Collections::emptyList).stream().filter(x -> cls.isAssignableFrom(x._2().getClass())).map(x -> (BaseComponent)x._2()).collect(Collectors.toList());
        ArrayList nonScene = new ArrayList();
        Optional<BaseComponent> first = list.stream().filter(x -> {
            OnScene onScene = x.getClass().getAnnotation(OnScene.class);
            if (onScene != null) {
                Set annotation = AnnotatedElementUtils.getMergedRepeatableAnnotations(x.getClass(), OnScene.class);
                if (!annotation.isEmpty()) {
                    return this.sceneMatcher.isMatch(annotation.toArray(new OnScene[0]), scenes);
                }
                nonScene.add(x);
            } else {
                nonScene.add(x);
            }
            return false;
        }).findFirst();
        if (first.isPresent()) {
            return (T)first.get();
        }
        if (!nonScene.isEmpty()) {
            return (T)((BaseComponent)nonScene.get(0));
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterSingletonsInstantiated() {
        AutowireCapableBeanFactory beanFactory2;
        try {
            beanFactory2 = this.applicationContext.getAutowireCapableBeanFactory();
            Map beansMapping = ((DefaultListableBeanFactory)beanFactory2).getBeansOfType(BaseComponent.class, true, true);
            beansMapping.values().forEach(x -> this.register(this.applicationContext.getId(), (BaseComponent)x));
        }
        catch (Exception beanFactory2) {
            // empty catch block
        }
        this.findByKind(BaseComponent.class).forEach(x -> {
            if (x instanceof PostInitAware) {
                ((PostInitAware)x).doPost();
            }
        });
        beanFactory2 = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
        Map pubSubs = beanFactory2.getBeansOfType(PubSub.class, true, true);
        Arrays.stream(PubSubRuntime.getInstance().listSubscribedTopics()).forEach(arg_0 -> this.lambda$afterSingletonsInstantiated$19(pubSubs, (DefaultListableBeanFactory)beanFactory2, arg_0));
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private /* synthetic */ void lambda$afterSingletonsInstantiated$19(Map pubSubs, DefaultListableBeanFactory beanFactory, TopicSubscription topicSubscription) {
        Optional<PubSub> pubSubOptional = pubSubs.values().stream().filter(pubSub -> pubSub.name().equals(topicSubscription.getPubsubName())).findFirst();
        if (pubSubOptional.isPresent()) {
            SubscribeRequest subscribeRequest = new SubscribeRequest();
            subscribeRequest.setTopic(topicSubscription.getTopic());
            subscribeRequest.setMetadata(topicSubscription.getMetadata());
            NewMessageHandler newMessageHandler = new NewMessageHandler(topicSubscription.getRoute());
            beanFactory.autowireBean((Object)newMessageHandler);
            pubSubOptional.get().subscribe(subscribeRequest, (Consumer)newMessageHandler);
        } else {
            this.log.warn("{} has not matched pubsub", (Object)topicSubscription);
        }
    }
}

