/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.actuator;

import com.xforceplus.tech.base.BaseComponent;
import com.xforceplus.tech.base.BaseComponentRegistry;
import com.xforceplus.tech.base.binding.OutputBinding;
import com.xforceplus.tech.spring.actuator.BaseComponentDTO;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.web.bind.annotation.GetMapping;

@RestControllerEndpoint(id="component-metadata")
public class ComponentEndpoint {
    @Autowired
    private BaseComponentRegistry registry;

    @GetMapping(value={"/components"})
    public List<BaseComponentDTO> componentList() {
        return this.registry.findByKind(BaseComponent.class).stream().map(baseComponent -> this.toBaseComponentDTO((BaseComponent)baseComponent)).collect(Collectors.toList());
    }

    private BaseComponentDTO toBaseComponentDTO(BaseComponent baseComponent) {
        BaseComponentDTO baseComponentDTO = new BaseComponentDTO();
        baseComponentDTO.setName(baseComponent.name());
        baseComponentDTO.setType(baseComponent.kind());
        baseComponentDTO.setMetadata(baseComponent.currentMetadata());
        if (baseComponent instanceof OutputBinding) {
            baseComponentDTO.setOperations(Arrays.asList(((OutputBinding)baseComponent).operations()));
        }
        return baseComponentDTO;
    }
}

