/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.api.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.tech.base.core.context.route.CommonResponse;
import com.xforceplus.tech.base.core.context.route.RouteInfo;
import com.xforceplus.tech.common.utils.JsonHelper;
import com.xforceplus.tech.spring.api.UserCenterGatewayApiService;
import com.xforceplus.tech.spring.api.vo.AuthTplVo;
import com.xforceplus.tech.spring.config.RouteConfiguration;
import com.xplat.ultraman.api.management.pojo.auth.AuthContentPlaceType;
import com.xplat.ultraman.api.management.pojo.auth.AuthTemplateType;
import com.xplat.ultraman.api.management.pojo.enums.Method;
import com.xplat.ultraman.api.management.restclient.agent.executor.AgentExecutor;
import com.xplat.ultraman.api.management.restclient.dto.AgentClient;
import com.xplat.ultraman.api.management.restclient.dto.AuthTemplate;
import com.xplat.ultraman.api.management.restclient.rest.ParameterTypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserCenterGatewayApiServiceImpl
implements UserCenterGatewayApiService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AgentExecutor restAgentExecutor;
    @Autowired
    private RouteConfiguration routeConfiguration;

    @Override
    public Map routeQuery(List<String> epList) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("epList", epList);
        params.put("appId", this.routeConfiguration.getAppId());
        params.put("env", this.routeConfiguration.getEnvId());
        if (!StringUtils.isEmpty((CharSequence)this.routeConfiguration.getLocalEpcpUrl())) {
            return this.routeQueryLocal(params);
        }
        this.log.debug("\u83b7\u53d6\u6269\u5c55\u70b9\u8def\u7531\u914d\u7f6e");
        String apiPath = "/global/epcp/v1/ep/route/query";
        AuthTplVo authIplVo = AuthTplVo.builder().templateCode("usercenter").env(this.routeConfiguration.getUserCenterEnv()).build();
        AgentClient agentClient = new AgentClient.AgentClientBuilder(this.getAuthTemplate(authIplVo), apiPath).method(Method.POST).body(params).parameterTypeReference((ParameterTypeReference)new ParameterTypeReference<CommonResponse<Map<String, List<RouteInfo>>>>(){}).builder();
        CommonResponse response = (CommonResponse)this.restAgentExecutor.execute(agentClient);
        if (1 == response.getCode()) {
            return (Map)response.getResult();
        }
        throw new Exception(response.getMessage());
    }

    private AuthTemplate getAuthTemplate(AuthTplVo authTpl) {
        return new AuthTemplate(authTpl.getEnv(), authTpl.getTemplateCode(), AuthTemplateType.JWT_AUTH, AuthContentPlaceType.LOCAl);
    }

    private Map routeQueryLocal(Map params) throws Exception {
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)JsonHelper.toJsonStr((Object)params));
        Request request = new Request.Builder().url(this.routeConfiguration.getLocalEpcpUrl() + "/v1/ep/route/query").method("POST", body).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request).execute();
        String responseBody = response.body().string();
        if (response.isSuccessful()) {
            CommonResponse result = (CommonResponse)JSONObject.parseObject((String)responseBody, (TypeReference)new TypeReference<CommonResponse<Map<String, List<RouteInfo>>>>(){}, (Feature[])new Feature[0]);
            if (1 == result.getCode()) {
                return (Map)result.getResult();
            }
            throw new Exception(result.getMessage());
        }
        throw new Exception("routeQueryLocal error." + response.code() + "-" + responseBody);
    }
}

