/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.dispatcher.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.infrastructure.plugin.extension.XExtension;
import com.xforceplus.tech.infrastructure.plugin.extension.XExtensionDefinition;
import com.xforceplus.tech.infrastructure.plugin.extension.XExtensionModule;
import com.xforceplus.tech.infrastructure.plugin.extension.XExtensionPoint;
import com.xforceplus.tech.spring.dispatcher.ExtentionServiceDispatcher;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

public class ExtentionServiceDispatcherImpl
implements ExtentionServiceDispatcher {
    @Autowired
    private final ApplicationContext applicationContext;
    @Autowired
    private final ContextService contextService;
    private final ObjectMapper objectMapper;

    public ExtentionServiceDispatcherImpl(ApplicationContext applicationContext, ContextService contextService) {
        this.applicationContext = applicationContext;
        this.contextService = contextService;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public Object invokeEp(Class epClass, Object ... args) {
        return null;
    }

    @Override
    public Object invokeEp(String epCode, Object ... args) {
        return null;
    }

    @Override
    public Object invokeEpImpl(String epImplCode, Object ... args) {
        ClassInfo epImplClassInfo = this.findEpImplClassInfo(epImplCode);
        Method implMethod = this.findEpImplClassMethod(epImplClassInfo);
        List<Object> params = this.convertToMethodParams(implMethod, args);
        Object result = ReflectionUtils.invokeMethod((Method)implMethod, (Object)this.applicationContext.getBean(epImplClassInfo.loadClass()), (Object[])params.toArray());
        return result;
    }

    private ClassInfo findEpImplClassInfo(String epImplCode) {
        ScanResult scan = new ClassGraph().disableJarScanning().enableAllInfo().scan();
        ClassInfoList xExtensionPointClassList = scan.getClassesImplementing(XExtensionPoint.class);
        String finalEpImplCode = epImplCode;
        Optional<ClassInfo> epImplClassOptional = xExtensionPointClassList.stream().filter(xExtentionPointClassItem -> {
            if (!xExtentionPointClassItem.hasAnnotation(XExtension.class)) {
                return false;
            }
            if (xExtentionPointClassItem.getClass().equals(XExtensionModule.class)) {
                return false;
            }
            String epImplCodeEach = ((AnnotationParameterValue)xExtentionPointClassItem.getAnnotationInfo(XExtension.class).getParameterValues().get("value")).getValue() + "";
            return epImplCodeEach.equals(finalEpImplCode);
        }).findFirst();
        if (!epImplClassOptional.isPresent()) {
            throw new RuntimeException("\u672a\u5339\u914d\u5230\u6269\u5c55\u70b9\u5b9e\u73b0");
        }
        ClassInfo epImplClassInfo = epImplClassOptional.get();
        return epImplClassInfo;
    }

    private Method findEpImplClassMethod(ClassInfo epImplClassInfo) {
        Optional<ClassInfo> parentClassOptional = epImplClassInfo.getInterfaces().stream().filter(epImplClassInfoItem -> epImplClassInfoItem.hasAnnotation(XExtensionDefinition.class)).findFirst();
        if (!parentClassOptional.isPresent()) {
            throw new RuntimeException("\u672a\u627e\u5230\u6269\u5c55\u70b9\u5b9a\u4e49\u63a5\u53e3\u7c7b");
        }
        MethodInfoList parentMethodInfo = parentClassOptional.get().getDeclaredMethodInfo();
        if (parentMethodInfo.size() == 0) {
            throw new RuntimeException("\u672a\u627e\u5230\u6269\u5c55\u70b9\u5b9a\u4e49\u65b9\u6cd5");
        }
        MethodInfo methodInfo = (MethodInfo)parentMethodInfo.get(0);
        MethodInfo implMethodInfo = epImplClassInfo.getMethodInfo().getSingleMethod(methodInfo.getName());
        Method implMethod = implMethodInfo.loadClassAndGetMethod();
        return implMethod;
    }

    private List<Object> convertToMethodParams(Method implMethod, Object ... args) {
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < implMethod.getParameterTypes().length; ++i) {
            Class<?> parameterType = implMethod.getParameterTypes()[i];
            Object param = this.objectMapper.convertValue(args[i], parameterType);
            params.add(param);
        }
        return params;
    }
}

