/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.endpoint;

import com.xforceplus.tech.base.binding.BindingClient;
import com.xforceplus.tech.base.binding.OutputBindingResponse;
import com.xforceplus.tech.base.binding.exception.BindingNotFoundException;
import com.xforceplus.tech.base.binding.exception.BindingOperationMissingException;
import com.xforceplus.tech.base.binding.exception.BindingOperationNotAcceptableException;
import com.xforceplus.tech.spring.endpoint.UnifierDTO;
import com.xforceplus.tech.spring.endpoint.UnifierResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import reactor.core.publisher.Mono;

@RequestMapping(value={"/v1/bindings"})
public class BindingController {
    @Autowired
    private BindingClient bindingClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/{bindingName}"})
    @ResponseBody
    public void bindingEndpoint(@PathVariable String bindingName, @RequestBody UnifierDTO unifierDTO, HttpServletResponse response) {
        response.setContentType("text/plain;charset=UTF-8");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            String operation = unifierDTO.getOperation();
            Object data = unifierDTO.getData();
            Map<String, Object> metadata = unifierDTO.getMetadata();
            Mono result = this.bindingClient.invokeMethod(bindingName, operation, data, metadata);
            OutputBindingResponse outputResponse = (OutputBindingResponse)result.block();
            Map metadataResponse = outputResponse.getMetadata();
            UnifierResponse unifierResponse = new UnifierResponse();
            unifierResponse.setData(outputResponse.getData());
            unifierResponse.setMetadata(metadata);
            response.setContentType("application/json;charset=UTF-8");
            List contentType = outputResponse.getContentType();
            byte[] dataResponse = outputResponse.getData();
            if (contentType.contains("application/json".toLowerCase()) || contentType.contains("text/plain".toLowerCase())) {
                String finalResponse = new String(dataResponse, StandardCharsets.UTF_8);
            } else {
                byte[] byArray = dataResponse;
            }
        }
        catch (Exception e) {
            if (e instanceof BindingOperationMissingException) {
                response.setStatus(400);
            } else if (e instanceof BindingNotFoundException) {
                response.setStatus(404);
            } else if (e instanceof BindingOperationNotAcceptableException) {
                response.setStatus(406);
            } else {
                response.setStatus(500);
            }
            e.printStackTrace();
            writer.print(e.getMessage());
        }
        finally {
            writer.flush();
            writer.close();
        }
    }
}

