/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.endpoint;

import com.xforceplus.tech.infrastructure.plugin.extension.update.PluginDetailInfo;
import com.xforceplus.tech.infrastructure.plugin.extension.update.UpdateManager;
import com.xforceplus.tech.spring.endpoint.dto.PluginCommonResponse;
import com.xforceplus.tech.spring.endpoint.dto.PluginInfo;
import com.xforceplus.tech.spring.endpoint.dto.PluginRequest;
import com.xforceplus.tech.spring.plugin.XSpringBootPluginManager;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginRuntimeException;
import org.pf4j.PluginState;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/v1/plugins"})
public class PluginManagerController {
    @Autowired
    private XSpringBootPluginManager pluginManager;
    @Autowired
    private UpdateManager updateManager;

    @PostMapping(value={"/repository/remove"})
    @ResponseBody
    public PluginCommonResponse removePlugin(@RequestBody PluginRequest request) {
        PluginCommonResponse response = new PluginCommonResponse();
        if (StringUtils.isEmpty((CharSequence)request.getPluginId())) {
            response.setCode(-1);
            response.setMessage("PluginId Missing");
            return response;
        }
        try {
            boolean hasInstalled = this.updateManager.uninstallPlugin(request.getPluginId());
            if (hasInstalled) {
                response.setCode(1);
            } else {
                response.setCode(-1);
            }
            return response;
        }
        catch (Exception ex) {
            response.setCode(-1);
            response.setMessage(Optional.ofNullable(ex.getMessage()).orElse("Error has no message"));
            return response;
        }
    }

    @GetMapping(value={"/repository/refresh"})
    @ResponseBody
    public PluginCommonResponse refreshAll() {
        this.updateManager.refresh();
        PluginCommonResponse commonResponse = new PluginCommonResponse();
        commonResponse.setCode(1);
        commonResponse.setMessage("OK");
        return commonResponse;
    }

    @GetMapping(value={"/repository/available"})
    @ResponseBody
    public List<PluginDetailInfo> listAll() {
        return this.updateManager.getAvailablePlugins();
    }

    @GetMapping(value={"/repository/available/{plugin-id}"})
    @ResponseBody
    public List<PluginDetailInfo.PluginRelease> listRelease(@PathVariable(value="plugin-id") String pluginId) {
        Optional<PluginDetailInfo> first = this.updateManager.getAvailablePlugins().stream().filter(x -> x.getId().equals(pluginId)).findFirst();
        if (first.isPresent()) {
            return first.get().getReleases();
        }
        return Collections.emptyList();
    }

    @PostMapping(value={"/plugin/update"})
    @ResponseBody
    public PluginCommonResponse updatePlugin(@RequestBody PluginRequest request) {
        PluginCommonResponse response = new PluginCommonResponse();
        if (StringUtils.isEmpty((CharSequence)request.getPluginId()) || StringUtils.isEmpty((CharSequence)request.getVersion())) {
            response.setCode(-1);
            response.setMessage("PluginId or Version Missing");
            return response;
        }
        try {
            boolean hasInstalled = this.updateManager.updatePlugin(request.getPluginId(), request.getVersion());
            if (hasInstalled) {
                response.setCode(1);
            } else {
                response.setCode(-1);
            }
            return response;
        }
        catch (Exception ex) {
            response.setCode(-1);
            response.setMessage(Optional.ofNullable(ex.getMessage()).orElse("Error has no message"));
            return response;
        }
    }

    @PostMapping(value={"/plugin/install"})
    @ResponseBody
    public PluginCommonResponse installPlugin(@RequestBody PluginRequest request) {
        PluginCommonResponse response = new PluginCommonResponse();
        if (StringUtils.isEmpty((CharSequence)request.getPluginId()) || StringUtils.isEmpty((CharSequence)request.getVersion())) {
            response.setCode(-1);
            response.setMessage("PluginId or Version Missing");
            return response;
        }
        try {
            boolean hasInstalled = this.updateManager.installPlugin(request.getPluginId(), request.getVersion());
            if (hasInstalled) {
                response.setCode(1);
            } else {
                response.setCode(-1);
            }
            return response;
        }
        catch (Exception ex) {
            response.setCode(-1);
            response.setMessage(Optional.ofNullable(ex.getMessage()).orElse("Error has no message"));
            return response;
        }
    }

    @MessageMapping(value={"plugin-list"})
    @GetMapping(value={"/list"})
    @ResponseBody
    public List<PluginInfo> list() {
        List loadedPlugins = this.pluginManager.getPlugins();
        List<PluginInfo> plugins = loadedPlugins.stream().map(pluginWrapper -> {
            PluginDescriptor descriptor = pluginWrapper.getDescriptor();
            PluginDescriptor latestDescriptor = null;
            try {
                latestDescriptor = this.pluginManager.getPluginDescriptorFinder().find(pluginWrapper.getPluginPath());
            }
            catch (PluginRuntimeException pluginRuntimeException) {
                // empty catch block
            }
            String newVersion = null;
            if (latestDescriptor != null && !descriptor.getVersion().equals(latestDescriptor.getVersion())) {
                newVersion = latestDescriptor.getVersion();
            }
            return PluginInfo.build(descriptor, pluginWrapper.getPluginState(), newVersion, latestDescriptor == null);
        }).collect(Collectors.toList());
        List pluginPaths = this.pluginManager.getPluginRepository().getPluginPaths();
        plugins.addAll(pluginPaths.stream().filter(path -> loadedPlugins.stream().noneMatch(plugin -> plugin.getPluginPath().equals(path))).map(path -> {
            PluginDescriptor descriptor = this.pluginManager.getPluginDescriptorFinder().find(path);
            return PluginInfo.build(descriptor, null, null, false);
        }).collect(Collectors.toList()));
        return plugins;
    }

    @MessageMapping(value={"plugin-start"})
    @PostMapping(value={"/start/{pluginId}"})
    @ResponseBody
    public int start(@PathVariable String pluginId) {
        this.pluginManager.startPlugin(pluginId);
        return 0;
    }

    @MessageMapping(value={"plugin-stop"})
    @PostMapping(value={"/stop/{pluginId}"})
    @ResponseBody
    public int stop(@PathVariable String pluginId) {
        this.pluginManager.stopPlugin(pluginId);
        return 0;
    }

    @PostMapping(value={"/reload/{pluginId}"})
    @ResponseBody
    public int reload(@PathVariable String pluginId) {
        PluginState pluginState = this.pluginManager.reloadPlugins(pluginId);
        return pluginState == PluginState.STARTED ? 0 : 1;
    }

    @PostMapping(value={"/reload-all"})
    @ResponseBody
    public int reloadAll() {
        this.pluginManager.reloadPlugins(false);
        return 0;
    }
}

