/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.endpoint;

import com.xforceplus.tech.spring.endpoint.dto.Metrics;
import com.xforceplus.tech.spring.plugin.XplatPlugin;
import java.util.HashMap;
import java.util.List;
import org.openjdk.jol.info.GraphLayout;
import org.pf4j.Plugin;
import org.pf4j.PluginManager;
import org.pf4j.PluginState;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(value={"/v1/profile"})
public class ProfileController {
    @Autowired
    private PluginManager pluginManager;
    @Autowired
    private ApplicationContext context;

    @MessageMapping(value={"totalSize"})
    @GetMapping(value={"/totalSize"})
    public Metrics totalSize() {
        HashMap<String, Long> memoryMetrics = new HashMap<String, Long>();
        if (this.context != null) {
            long memMemory = GraphLayout.parseInstance((Object[])new Object[]{this.context}).totalSize();
            memoryMetrics.put("_main", memMemory);
        }
        List plugins = this.pluginManager.getPlugins();
        plugins.stream().filter(plugin -> plugin.getPluginState() == PluginState.STARTED).forEach(plugin -> {
            Plugin xplat = plugin.getPlugin();
            if (xplat instanceof XplatPlugin) {
                GenericApplicationContext applicationContext = ((XplatPlugin)xplat).getApplicationContext();
                long memMemory = GraphLayout.parseInstance((Object[])new Object[]{applicationContext}).totalSize();
                memoryMetrics.put(xplat.getWrapper().getPluginId(), memMemory);
            } else {
                memoryMetrics.put(xplat.getWrapper().getPluginId(), -1L);
            }
        });
        Metrics metrics = new Metrics();
        metrics.setMemory(memoryMetrics);
        return metrics;
    }
}

