/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.plugin;

import com.xforceplus.tech.spring.plugin.XplatPlugin;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class PluginRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    public void detectHandlerMethods(Object controller) {
        super.detectHandlerMethods(controller);
    }

    public void registerControllers(XplatPlugin xplatPlugin) {
        this.getControllerBeans(xplatPlugin).forEach(bean -> this.registerController(xplatPlugin, bean));
    }

    private void registerController(XplatPlugin xplatPlugin, Object controller) {
        String beanName = controller.getClass().getName();
        this.unregisterController(xplatPlugin.getMainApplicationContext(), controller);
        xplatPlugin.registerBeanToMainContext(beanName, controller);
        this.detectHandlerMethods(controller);
    }

    public void unregisterControllers(XplatPlugin springBootPlugin) {
        this.getControllerBeans(springBootPlugin).forEach(bean -> this.unregisterController(springBootPlugin.getMainApplicationContext(), bean));
    }

    public Set<Object> getControllerBeans(XplatPlugin plugin) {
        LinkedHashSet<Object> beans = new LinkedHashSet<Object>();
        GenericApplicationContext applicationContext = plugin.getApplicationContext();
        Set sharedBeanNames = (Set)applicationContext.getBean("sharedBeanNames");
        beans.addAll(applicationContext.getBeansWithAnnotation(Controller.class).entrySet().stream().filter(beanEntry -> !sharedBeanNames.contains(beanEntry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()));
        beans.addAll(applicationContext.getBeansWithAnnotation(RestController.class).entrySet().stream().filter(beanEntry -> !sharedBeanNames.contains(beanEntry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()));
        return beans;
    }

    public void unregisterController(GenericApplicationContext mainCtx, Object controller) {
        new HashMap<RequestMappingInfo, HandlerMethod>(this.getHandlerMethods()).forEach((mapping, handlerMethod) -> {
            if (controller == handlerMethod.getBean()) {
                super.unregisterMapping(mapping);
            }
        });
        mainCtx.getBeanFactory().destroyBean(controller);
    }
}

