/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.plugin;

import com.xforceplus.tech.spring.plugin.XSpringBootPluginManager;
import com.xforceplus.tech.spring.plugin.XplatPlugin;
import org.pf4j.ExtensionFactory;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.support.GenericApplicationContext;

public class SpringExtensionFactory
implements ExtensionFactory {
    private static final Logger log = LoggerFactory.getLogger(SpringExtensionFactory.class);
    private XSpringBootPluginManager springBootPluginManager;

    public SpringExtensionFactory(XSpringBootPluginManager pluginManager) {
        this.springBootPluginManager = pluginManager;
    }

    public <T> T create(Class<T> extensionClass) {
        GenericApplicationContext pluginApplicationContext = this.getApplicationContext(extensionClass);
        Object extension = null;
        try {
            extension = pluginApplicationContext.getBean(extensionClass);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (extension == null) {
            Object bean;
            RootBeanDefinition beanDefinition = new RootBeanDefinition();
            beanDefinition.setBeanClass(extensionClass);
            beanDefinition.setPrimary(false);
            beanDefinition.setAutowireCandidate(true);
            extension = bean = pluginApplicationContext.getBeanFactory().createBean(extensionClass, 1, true);
            pluginApplicationContext.getBeanFactory().registerSingleton(extensionClass.getName(), extension);
        }
        return (T)extension;
    }

    public String getExtensionBeanName(Class<?> extensionClass) {
        GenericApplicationContext pluginAppCtx = this.getApplicationContext(extensionClass);
        if (pluginAppCtx == null) {
            return null;
        }
        String[] beanNames = pluginAppCtx.getBeanNamesForType(extensionClass);
        return beanNames.length > 0 ? beanNames[0] : null;
    }

    private Object createWithoutSpring(Class<?> extensionClass) {
        try {
            return extensionClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private GenericApplicationContext getApplicationContext(Class<?> extensionClass) {
        PluginWrapper pluginWrapper = this.springBootPluginManager.whichPlugin(extensionClass);
        if (pluginWrapper == null) {
            return this.springBootPluginManager.getApplicationContext();
        }
        XplatPlugin plugin = (XplatPlugin)pluginWrapper.getPlugin();
        return plugin.getApplicationContext();
    }
}

