/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.plugin;

import com.xforceplus.tech.base.core.context.route.RouteConfigContext;
import com.xforceplus.tech.infrastructure.plugin.extension.XExtension;
import com.xforceplus.tech.infrastructure.plugin.extension.XExtensionDefinition;
import com.xforceplus.tech.infrastructure.plugin.extension.XExtensionModule;
import com.xforceplus.tech.infrastructure.plugin.extension.XExtensionPoint;
import com.xforceplus.tech.infrastructure.plugin.extension.dynamic.XPluginManager;
import com.xforceplus.tech.spring.plugin.SpringExtensionFactory;
import com.xforceplus.tech.spring.plugin.runtime.ExtensionAutoProxy;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import org.pf4j.ExtensionFactory;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginRepository;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;

public class XSpringBootPluginManager
extends XPluginManager
implements ApplicationContextAware {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean autoStartPlugin = true;
    private String[] profiles;
    private Map<String, Object> presetProperties;
    private PluginRepository pluginRepository;
    private GenericApplicationContext applicationContext;
    private ExtensionAutoProxy autoProxy;
    private RouteConfigContext routeConfigService;

    public XSpringBootPluginManager(ExtensionAutoProxy autoProxy, RouteConfigContext routeConfigService) {
        this.autoProxy = autoProxy;
        this.routeConfigService = routeConfigService;
        this.init();
    }

    public XSpringBootPluginManager(Path pluginsRoot, ExtensionAutoProxy autoProxy, RouteConfigContext routeConfigContext) {
        super(pluginsRoot);
        this.autoProxy = autoProxy;
        this.routeConfigService = routeConfigContext;
        this.init();
    }

    public void scanAndInitExtensionBean() throws Exception {
        ScanResult scan = new ClassGraph().enableAllInfo().scan();
        ClassInfoList xExtensionPointList = scan.getClassesImplementing(XExtensionPoint.class);
        ArrayList epDefinitionClassInfoList = new ArrayList();
        xExtensionPointList.forEach(classInfo -> {
            Class targetClass;
            boolean isSub = classInfo.hasAnnotation(XExtension.class);
            if (!isSub && classInfo.isInterface() && (targetClass = classInfo.loadClass()) != XExtensionModule.class) {
                this.registerExtension(targetClass);
                if (classInfo.getAnnotationInfo(XExtensionDefinition.class) != null) {
                    epDefinitionClassInfoList.add(classInfo);
                }
            }
        });
        ArrayList routeQueryEpList = new ArrayList();
        epDefinitionClassInfoList.forEach(classInfo -> {
            String epCode = ((AnnotationParameterValue)classInfo.getAnnotationInfo(XExtensionDefinition.class).getParameterValues().get("value")).getValue() + "";
            routeQueryEpList.add(epCode);
            this.log.debug("\u626b\u63cf\u5230\u6269\u5c55\u70b9 -- " + epCode);
        });
        this.routeConfigService.setEpList(routeQueryEpList);
    }

    private <T> void registerExtension(Class<T> tClass) {
        T t = this.autoProxy.initInstance(tClass, this.applicationContext.getClassLoader(), this);
        this.applicationContext.getBeanFactory().registerSingleton(tClass.getTypeName(), t);
    }

    public GenericApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Map<String, Object> getPresetProperties() {
        return this.presetProperties;
    }

    protected ExtensionFactory createExtensionFactory() {
        return new SpringExtensionFactory(this);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (GenericApplicationContext)applicationContext;
    }

    public PluginDescriptorFinder getPluginDescriptorFinder() {
        return super.getPluginDescriptorFinder();
    }

    protected PluginRepository createPluginRepository() {
        this.pluginRepository = super.createPluginRepository();
        return this.pluginRepository;
    }

    public PluginRepository getPluginRepository() {
        return this.pluginRepository;
    }

    public void setAutoStartPlugin(boolean autoStartPlugin) {
        this.autoStartPlugin = autoStartPlugin;
    }

    public boolean isAutoStartPlugin() {
        return this.autoStartPlugin;
    }

    public void setProfiles(String[] profiles) {
        this.profiles = profiles;
    }

    public String[] getProfiles() {
        return this.profiles;
    }

    public void init() {
        this.loadPlugins();
    }

    public void startPlugins() {
        super.startPlugins();
    }

    public PluginState startPlugin(String pluginId) {
        return super.startPlugin(pluginId);
    }

    public void stopPlugins() {
        super.stopPlugins();
    }

    public PluginState stopPlugin(String pluginId) {
        return super.stopPlugin(pluginId);
    }

    public void restartPlugins() {
        this.stopPlugins();
        this.startPlugins();
    }

    public PluginState restartPlugin(String pluginId) {
        PluginState pluginState = this.stopPlugin(pluginId, false);
        if (pluginState != PluginState.STARTED) {
            this.startPlugin(pluginId);
        }
        return pluginState;
    }

    public void reloadPlugins(boolean restartStartedOnly) {
        this.stopPlugins();
        ArrayList startedPluginIds = new ArrayList();
        this.getPlugins().forEach(plugin -> {
            if (plugin.getPluginState() == PluginState.STARTED) {
                startedPluginIds.add(plugin.getPluginId());
            }
            this.unloadPlugin(plugin.getPluginId());
        });
        this.loadPlugins();
        if (restartStartedOnly) {
            startedPluginIds.forEach(pluginId -> {
                if (this.getPlugin((String)pluginId) != null) {
                    this.startPlugin((String)pluginId);
                }
            });
        } else {
            this.startPlugins();
        }
    }

    public PluginState reloadPlugins(String pluginId) {
        PluginWrapper plugin = this.getPlugin(pluginId);
        this.stopPlugin(pluginId, false);
        this.unloadPlugin(pluginId, false);
        try {
            this.loadPlugin(plugin.getPluginPath());
        }
        catch (Exception ex) {
            return null;
        }
        return this.startPlugin(pluginId);
    }
}

