/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.plugin;

import com.xforceplus.tech.base.BaseComponent;
import com.xforceplus.tech.base.BaseComponentRegistry;
import com.xforceplus.tech.base.scene.DynamicSceneProvider;
import com.xforceplus.tech.infrastructure.plugin.extension.XExtensionModule;
import com.xforceplus.tech.spring.plugin.PluginRequestMappingHandlerMapping;
import com.xforceplus.tech.spring.plugin.SpringExtensionFactory;
import com.xforceplus.tech.spring.plugin.XSpringBootPluginManager;
import com.xforceplus.tech.spring.plugin.runtime.ApplicationContextProvider;
import com.xforceplus.tech.spring.plugin.runtime.SpringBootstrap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.pf4j.Plugin;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.Assert;

public class XplatPlugin
extends Plugin {
    private static Logger log = LoggerFactory.getLogger(Plugin.class);
    private final SpringBootstrap springBootstrap;
    private ApplicationContext applicationContext;
    private final Set<String> injectedExtensionNames = new HashSet<String>();

    public XplatPlugin(PluginWrapper wrapper) {
        super(wrapper);
        this.springBootstrap = this.createSpringBootstrap();
    }

    private PluginRequestMappingHandlerMapping getMainRequestMapping() {
        return (PluginRequestMappingHandlerMapping)((Object)this.getMainApplicationContext().getBean("requestMappingHandlerMapping"));
    }

    public void releaseAdditionalResources() {
    }

    public void delete() {
    }

    public void start() {
        if (this.getWrapper().getPluginState() == PluginState.STARTED) {
            return;
        }
        this.applicationContext = this.springBootstrap.run(new String[0]);
        try {
            log.info("try to load component");
            BaseComponentRegistry registry = (BaseComponentRegistry)this.applicationContext.getBean(BaseComponentRegistry.class);
            Map beansOfType = this.applicationContext.getBeansOfType(BaseComponent.class);
            beansOfType.forEach((k, v) -> registry.register(this.applicationContext.getId(), v));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Map providers = this.applicationContext.getBeansOfType(DynamicSceneProvider.class);
        for (String providerName : providers.keySet()) {
            this.registerBeanToMainContext(providerName, providers.get(providerName));
            this.injectedExtensionNames.add(providerName);
        }
        Set extensionClassNames = Optional.ofNullable(this.getWrapper().getPluginManager().getExtensionClassNames(this.getWrapper().getPluginId())).orElseGet(Collections::emptySet);
        for (String extensionClassName : extensionClassNames) {
            try {
                log.debug("Register extension <{}> to main ApplicationContext", (Object)extensionClassName);
                Class<?> extensionClass = this.getWrapper().getPluginClassLoader().loadClass(extensionClassName);
                if (!XExtensionModule.class.isAssignableFrom(extensionClass)) continue;
                SpringExtensionFactory extensionFactory = (SpringExtensionFactory)this.getWrapper().getPluginManager().getExtensionFactory();
                Object bean = extensionFactory.create(extensionClass);
                String beanName = extensionFactory.getExtensionBeanName(extensionClass);
                this.registerBeanToMainContext(beanName, bean);
                this.injectedExtensionNames.add(beanName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        ApplicationContextProvider.registerApplicationContext(this.applicationContext);
        log.debug("Plugin {} is started in ", (Object)this.getWrapper().getPluginId());
    }

    public void stop() {
        if (this.getWrapper().getPluginState() != PluginState.STARTED) {
            return;
        }
        log.debug("Stopping plugin {} ......", (Object)this.getWrapper().getPluginId());
        for (String extensionName : this.injectedExtensionNames) {
            log.debug("Unregister extension <{}> to main ApplicationContext", (Object)extensionName);
            this.unregisterBeanFromMainContext(extensionName);
        }
        try {
            BaseComponentRegistry registry = (BaseComponentRegistry)this.applicationContext.getBean(BaseComponentRegistry.class);
            registry.unRegister(this.applicationContext.getId());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ApplicationContextProvider.unregisterApplicationContext(this.applicationContext);
        this.injectedExtensionNames.clear();
        ((ConfigurableApplicationContext)this.applicationContext).close();
        log.debug("Plugin {} is stopped", (Object)this.getWrapper().getPluginId());
    }

    public Class getStarterClass() {
        return null;
    }

    protected SpringBootstrap createSpringBootstrap() {
        return new SpringBootstrap(this, this.getStarterClass());
    }

    public GenericApplicationContext getApplicationContext() {
        return (GenericApplicationContext)this.applicationContext;
    }

    public XSpringBootPluginManager getPluginManager() {
        return (XSpringBootPluginManager)this.getWrapper().getPluginManager();
    }

    public GenericApplicationContext getMainApplicationContext() {
        return this.getPluginManager().getApplicationContext();
    }

    public void registerBeanToMainContext(String beanName, Object bean) {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        beanName = StringUtils.isEmpty((CharSequence)beanName) ? bean.getClass().getName() : beanName;
        this.getMainApplicationContext().getBeanFactory().registerSingleton(beanName, bean);
    }

    public void unregisterBeanFromMainContext(String beanName) {
        XplatPlugin.unregisterBeanFromMainContext(this.getMainApplicationContext(), beanName);
        Assert.notNull((Object)beanName, (String)"bean must not be null");
        ((AbstractAutowireCapableBeanFactory)this.getMainApplicationContext().getBeanFactory()).destroySingleton(beanName);
    }

    public void unregisterBeanFromMainContext(Object bean) {
        XplatPlugin.unregisterBeanFromMainContext(this.getMainApplicationContext(), bean);
    }

    public static void unregisterBeanFromMainContext(GenericApplicationContext mainCtx, String beanName) {
        Assert.notNull((Object)beanName, (String)"bean must not be null");
        ((AbstractAutowireCapableBeanFactory)mainCtx.getBeanFactory()).destroySingleton(beanName);
    }

    public static void unregisterBeanFromMainContext(GenericApplicationContext mainCtx, Object bean) {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        String beanName = bean.getClass().getName();
        ((AbstractAutowireCapableBeanFactory)mainCtx.getBeanFactory()).destroySingleton(beanName);
    }
}

