/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.plugin.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.tech.base.anno.OnScene;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.core.context.route.CommonResponse;
import com.xforceplus.tech.base.core.context.route.RouteConfigContext;
import com.xforceplus.tech.base.core.context.route.RouteInfo;
import com.xforceplus.tech.base.scene.DynamicSceneProvider;
import com.xforceplus.tech.base.scene.Scene;
import com.xforceplus.tech.infrastructure.plugin.extension.XExtension;
import com.xforceplus.tech.infrastructure.plugin.extension.XExtensionDefinition;
import com.xforceplus.tech.spring.plugin.runtime.ExtensionAutoProxy;
import com.xforceplus.tech.spring.plugin.runtime.SceneMatcher;
import com.xforceplus.tech.spring.plugin.runtime.exception.XepImplementNotFoundException;
import com.xplat.ultraman.api.management.restclient.rest.OkHttpUtils;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultExtensionMethodDispatcher
implements ExtensionAutoProxy.ExtensionMethodDispatcher {
    private Logger log = LoggerFactory.getLogger(DefaultExtensionMethodDispatcher.class);
    private final ContextService contextService;
    private final RouteConfigContext routeConfigService;
    private final List<DynamicSceneProvider> sceneProviders;
    private final SceneMatcher sceneMatcher;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final OkHttpUtils okHttpUtils;

    public DefaultExtensionMethodDispatcher(ContextService contextService, RouteConfigContext routeConfigService, List<DynamicSceneProvider> sceneProviders, SceneMatcher sceneMatcher) {
        this.contextService = contextService;
        this.routeConfigService = routeConfigService;
        this.sceneProviders = sceneProviders;
        this.sceneMatcher = sceneMatcher;
        this.okHttpUtils = OkHttpUtils.getInstance((long)60L, (long)60L, (long)60L, (int)0);
    }

    @Override
    public Object dispatch(Class targetClass, List<Object> candidates, Method method, Object[] args) throws Exception {
        String tenantCode;
        XExtensionDefinition xExtensionDefinition = targetClass.getAnnotation(XExtensionDefinition.class);
        if (xExtensionDefinition == null) {
            throw new XepImplementNotFoundException("\u65e0\u6cd5\u83b7\u53d6\u5230\u6269\u5c55\u70b9\u6ce8\u89e3\u4fe1\u606f");
        }
        String epCode = xExtensionDefinition.value();
        RouteInfo routeInfo = this.routeConfigService.getMatchConfig(epCode, tenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY) + "", args);
        if (routeInfo == null) {
            Object result = this.fetchByScene(candidates);
            return method.invoke(result, args);
        }
        switch (routeInfo.getEpImplType()) {
            case 1: 
            case 2: {
                Object result = this.fetchByRoute(candidates, routeInfo);
                if (result == null) {
                    throw new XepImplementNotFoundException("\u672a\u5339\u914d\u5230\u6269\u5c55\u8def\u7531\u914d\u7f6e");
                }
                return method.invoke(result, args);
            }
            case 3: {
                return this.remoteInvoke(routeInfo, method, args);
            }
            case 4: {
                break;
            }
            default: {
                throw new XepImplementNotFoundException("\u672a\u5339\u914d\u5230\u6269\u5c55\u70b9\u5b9e\u73b0: " + routeInfo.getEpImplType());
            }
        }
        throw new RuntimeException("\u5339\u914d\u6269\u5c55\u5b9e\u73b0\u5f02\u5e38");
    }

    public Object remoteInvoke(RouteInfo routeInfo, Method method, Object[] args) throws Exception {
        CommonResponse commonResponse;
        String url;
        Response response;
        ResponseBody responseBody;
        String resultBody;
        HashMap<String, String> header;
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)this.objectMapper.writeValueAsString((Object)args));
        String xepContext = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.XEP_CONTEXT_REQUEST_HEADER);
        HashMap<String, String> hashMap = header = routeInfo.getHeader() == null ? null : (HashMap<String, String>)this.objectMapper.readValue(routeInfo.getHeader(), Map.class);
        if (!StringUtils.isEmpty((Object)xepContext)) {
            if (header == null) {
                header = new HashMap<String, String>();
            }
            header.put("x-xep-context", URLEncoder.encode(xepContext, "UTF-8"));
        }
        String string = resultBody = (responseBody = (response = this.okHttpUtils.post(url = routeInfo.getHost() + "/v1/epcp/remote/invoke/" + routeInfo.getEpImplCode(), body, header)).body()) == null ? "" : responseBody.string();
        if (!response.isSuccessful()) {
            throw new RuntimeException(response.code() + "_" + resultBody);
        }
        if (!StringUtils.isEmpty((Object)response.header("x-xep-context"))) {
            try {
                this.log.debug("\u8fdc\u7a0b\u8c03\u7528\u89e3\u6790\u5934\u4fe1\u606fx-xep-context");
                String decode = URLDecoder.decode(xepContext, "UTF-8");
                this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.XEP_CONTEXT_RESPONSE_HEADER, (Object)decode);
            }
            catch (Exception e) {
                this.log.error("\u8fdc\u7a0b\u8c03\u7528\u89e3\u6790\u5934\u4fe1\u606fx-xep-context\u5f02\u5e38\uff1a" + e.getMessage());
                throw e;
            }
        }
        if ((commonResponse = (CommonResponse)this.objectMapper.readValue(resultBody, CommonResponse.class)).getCode() == 1) {
            if (commonResponse.getResult() != null) {
                Class<?> returnType = method.getReturnType();
                return this.objectMapper.convertValue(commonResponse.getResult(), returnType);
            }
            return null;
        }
        throw new RuntimeException(commonResponse.getMessage());
    }

    public Object fetchByRoute(List<Object> candidates, RouteInfo routeInfo) {
        Optional<Object> first = candidates.stream().filter(x -> {
            XExtension annotation = x.getClass().getAnnotation(XExtension.class);
            if (annotation == null) {
                return false;
            }
            String epImplCode = annotation.value();
            return routeInfo.getEpImplCode().equals(epImplCode);
        }).findFirst();
        return first.orElse(null);
    }

    public Object fetchByScene(List<Object> candidates) {
        List sceneViaContext = this.sceneProviders.stream().flatMap(x -> x.getSceneViaContext(this.contextService.getAll()).stream()).collect(Collectors.toList());
        ArrayList defaultCandidates = new ArrayList();
        Optional<Object> first = candidates.stream().filter(x -> {
            XExtension annotation = x.getClass().getAnnotation(XExtension.class);
            if (annotation == null) {
                return false;
            }
            OnScene[] scenes = annotation.scenes();
            boolean isDefault = annotation.isDefault();
            if (isDefault) {
                defaultCandidates.add(x);
            }
            return this.sceneMatcher.isMatch(scenes, (List<Scene>)sceneViaContext);
        }).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        if (defaultCandidates.isEmpty()) {
            throw new XepImplementNotFoundException("\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u6269\u5c55\u5b9e\u73b0");
        }
        return defaultCandidates.get(0);
    }
}

