/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.plugin.runtime;

import com.xforceplus.tech.infrastructure.plugin.extension.XExtensionPoint;
import com.xforceplus.tech.infrastructure.plugin.extension.dynamic.XPluginManager;
import com.xforceplus.tech.spring.plugin.runtime.exception.XepImplementNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.cglib.core.ClassLoaderAwareGeneratorStrategy;
import org.springframework.cglib.core.GeneratorStrategy;
import org.springframework.cglib.core.NamingPolicy;
import org.springframework.cglib.core.SpringNamingPolicy;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.CallbackFilter;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.util.Assert;

public class ExtensionAutoProxy {
    private ExtensionMethodDispatcher extensionMethodDispatcher;

    public ExtensionAutoProxy() {
        this.extensionMethodDispatcher = new PickFirst();
    }

    public ExtensionAutoProxy(ExtensionMethodDispatcher extensionMethodDispatcher) {
        this.extensionMethodDispatcher = extensionMethodDispatcher;
    }

    public <T> T initInstance(Class<T> targetClass, ClassLoader classLoader, XPluginManager pluginManager) {
        Assert.isTrue((boolean)XExtensionPoint.class.isAssignableFrom(targetClass), (String)"Only Extension is supported");
        Class<?> enhancedSubclass = this.createEnhancedSubclass(targetClass, classLoader);
        Object instance = BeanUtils.instantiateClass(enhancedSubclass);
        Factory factory = (Factory)instance;
        factory.setCallbacks(new Callback[]{new LookupOverrideMethodInterceptor(pluginManager, this.extensionMethodDispatcher, targetClass)});
        return (T)factory;
    }

    public Class<?> createEnhancedSubclass(Class target, ClassLoader classLoader) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(target);
        enhancer.setNamingPolicy((NamingPolicy)SpringNamingPolicy.INSTANCE);
        enhancer.setStrategy((GeneratorStrategy)new ClassLoaderAwareGeneratorStrategy(classLoader));
        enhancer.setCallbackTypes(new Class[]{LookupOverrideMethodInterceptor.class});
        enhancer.setCallbackFilter((CallbackFilter)new MethodOverrideCallbackFilter());
        return enhancer.createClass();
    }

    private static class LookupOverrideMethodInterceptor
    implements MethodInterceptor {
        private final XPluginManager manager;
        private Class targetClass;
        private ExtensionMethodDispatcher extensionMethodDispatcher;

        public LookupOverrideMethodInterceptor(XPluginManager manager, ExtensionMethodDispatcher extensionMethodDispatcher, Class targetClass) {
            this.manager = manager;
            this.targetClass = targetClass;
            this.extensionMethodDispatcher = extensionMethodDispatcher;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy mp) throws Throwable {
            List extensionInstance = this.manager.getExtensions(this.targetClass);
            return this.extensionMethodDispatcher.dispatch(this.targetClass, extensionInstance, method, args);
        }
    }

    private static class MethodOverrideCallbackFilter
    implements CallbackFilter {
        public int accept(Method method) {
            return 0;
        }
    }

    public static class PickFirst
    implements ExtensionMethodDispatcher {
        @Override
        public Object dispatch(Class targetClass, List<Object> candidates, Method method, Object[] args) {
            if (!candidates.isEmpty()) {
                return candidates.get(0);
            }
            throw new XepImplementNotFoundException("Candidates is empty");
        }
    }

    public static interface ExtensionMethodDispatcher {
        public Object dispatch(Class var1, List<Object> var2, Method var3, Object[] var4) throws InvocationTargetException, IllegalAccessException, IOException, Exception;
    }
}

