/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.plugin.runtime;

import com.xforceplus.tech.base.core.context.route.RouteConfigContext;
import com.xforceplus.tech.spring.api.UserCenterGatewayApiService;
import com.xforceplus.tech.spring.config.RouteConfiguration;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;

public class RouteConfigInitListener
implements ApplicationListener<ApplicationStartedEvent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    RouteConfigContext routeConfigContext;
    @Autowired
    RouteConfiguration routeConfiguration;
    @Autowired
    UserCenterGatewayApiService userCenterGatewayApiService;
    ScheduledExecutorService scheduledExecutorService = null;

    public void onApplicationEvent(ApplicationStartedEvent event) {
        block4: {
            Map routeInfos = null;
            try {
                routeInfos = this.userCenterGatewayApiService.routeQuery(this.routeConfigContext.getEpList());
                this.routeConfigContext.initRouteConfig(routeInfos);
                this.routeConfigContext.saveCacheConfigByFile();
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
                if (this.routeConfigContext.initRouteConfigByCacheFile()) break block4;
                throw e;
            }
        }
        this.initSchedule();
    }

    private void initSchedule() {
        if (this.scheduledExecutorService != null) {
            return;
        }
        this.scheduledExecutorService = Executors.newScheduledThreadPool(2);
        this.scheduledExecutorService.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    Map routeInfos = RouteConfigInitListener.this.userCenterGatewayApiService.routeQuery(RouteConfigInitListener.this.routeConfigContext.getEpList());
                    RouteConfigInitListener.this.routeConfigContext.updateRouteConfig(routeInfos);
                    RouteConfigInitListener.this.routeConfigContext.saveCacheConfigByFile();
                }
                catch (Exception e) {
                    RouteConfigInitListener.this.log.error("", (Throwable)e);
                }
            }
        }, 300L, 600L, TimeUnit.SECONDS);
    }
}

