/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.plugin.runtime;

import com.xforceplus.tech.base.anno.OnScene;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.scene.DynamicSceneProvider;
import com.xforceplus.tech.base.scene.Scene;
import com.xforceplus.tech.infrastructure.plugin.extension.XExtension;
import com.xforceplus.tech.spring.plugin.runtime.ExtensionAutoProxy;
import com.xforceplus.tech.spring.plugin.runtime.SceneMatcher;
import com.xforceplus.tech.spring.plugin.runtime.exception.XepImplementNotFoundException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.core.annotation.AnnotationUtils;

public class SceneAwareMethodDispatcher
implements ExtensionAutoProxy.ExtensionMethodDispatcher {
    private final List<DynamicSceneProvider> sceneProviders;
    private final ContextService contextService;
    private final SceneMatcher sceneMatcher;

    public SceneAwareMethodDispatcher(List<DynamicSceneProvider> sceneProviders, ContextService contextService, SceneMatcher sceneMatcher) {
        this.sceneProviders = sceneProviders;
        this.contextService = contextService;
        this.sceneMatcher = sceneMatcher;
    }

    @Override
    public Object dispatch(Class targetClass, List<Object> candidates, Method method, Object[] args) {
        List sceneViaContext = this.sceneProviders.stream().flatMap(x -> x.getSceneViaContext(this.contextService.getAll()).stream()).collect(Collectors.toList());
        ArrayList noSceneCandidates = new ArrayList();
        Optional<Object> first = candidates.stream().filter(x -> {
            XExtension xExtension = x.getClass().getAnnotation(XExtension.class);
            if (xExtension != null) {
                XExtension annotation = (XExtension)AnnotationUtils.getAnnotation(x.getClass(), XExtension.class);
                if (annotation != null) {
                    OnScene[] scenes = annotation.scenes();
                    if (scenes.length == 0) {
                        noSceneCandidates.add(x);
                    }
                    boolean match = this.sceneMatcher.isMatch(scenes, (List<Scene>)sceneViaContext);
                    return match;
                }
                return false;
            }
            return false;
        }).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        if (noSceneCandidates.isEmpty()) {
            throw new XepImplementNotFoundException("\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u6269\u5c55\u5b9e\u73b0");
        }
        return noSceneCandidates.get(0);
    }
}

