/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.plugin.runtime;

import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import org.pf4j.ClassLoadingStrategy;
import org.pf4j.PluginClassLoader;
import org.pf4j.PluginDependency;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class XplatPluginClassloader
extends PluginClassLoader {
    private static final Logger log = LoggerFactory.getLogger(XplatPluginClassloader.class);
    private List<String> pluginFirstClasses;
    private List<String> pluginOnlyResources;
    private PluginManager pluginManager;
    private PluginDescriptor pluginDescriptor;

    public XplatPluginClassloader(PluginManager pluginManager, PluginDescriptor pluginDescriptor, ClassLoader parent) {
        super(pluginManager, pluginDescriptor, parent, ClassLoadingStrategy.APD);
        this.pluginManager = pluginManager;
        this.pluginDescriptor = pluginDescriptor;
    }

    public void setPluginFirstClasses(@NonNull List<String> pluginFirstClasses) {
        this.pluginFirstClasses = pluginFirstClasses.stream().map(pluginFirstClass -> pluginFirstClass.replaceAll(".", "[$0]").replace("[*]", ".*?").replace("[?]", ".?")).collect(Collectors.toList());
    }

    public void setPluginOnlyResources(@NonNull List<String> pluginOnlyResources) {
        this.pluginOnlyResources = pluginOnlyResources.stream().map(pluginFirstClass -> pluginFirstClass.replaceAll(".", "[$0]").replace("[*]", ".*?").replace("[?]", ".?")).collect(Collectors.toList());
    }

    public URL getResource(String name) {
        if (name.endsWith(".class")) {
            return super.getResource(name);
        }
        URL url = this.findResource(name);
        if (url != null) {
            log.trace("Found resource '{}' in plugin classpath", (Object)name);
            return url;
        }
        log.trace("Couldn't find resource '{}' in plugin classpath. Delegating to parent", (Object)name);
        return super.getResource(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return super.getResources(name);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return super.loadClass(className);
    }

    protected Class<?> getLoadedClass(String className) {
        return this.findLoadedClass(className);
    }

    protected Class<?> loadClassFromDependencies(String className) {
        log.trace("Search in dependencies for class '{}'", (Object)className);
        List dependencies = this.pluginDescriptor.getDependencies();
        for (PluginDependency dependency : dependencies) {
            ClassLoader classLoader = this.pluginManager.getPluginClassLoader(dependency.getPluginId());
            if (classLoader == null && dependency.isOptional()) continue;
            try {
                if (classLoader instanceof XplatPluginClassloader) {
                    Class<?> clazz = ((XplatPluginClassloader)((Object)classLoader)).getLoadedClass(className);
                    if (clazz != null) {
                        return clazz;
                    }
                    clazz = ((XplatPluginClassloader)((Object)classLoader)).loadClassFromDependencies(className);
                    if (clazz == null) continue;
                    return clazz;
                }
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    protected URL findResourceFromDependencies(String name) {
        if (!name.endsWith(".class")) {
            return null;
        }
        return super.findResourceFromDependencies(name);
    }

    protected Collection<URL> findResourcesFromDependencies(String name) throws IOException {
        if (!name.endsWith(".class")) {
            return Collections.emptyList();
        }
        return super.findResourcesFromDependencies(name);
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        Permissions permissions = new Permissions();
        return permissions;
    }
}

