/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.plugin.runtime.security;

import java.lang.reflect.ReflectPermission;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import org.pf4j.PluginClassLoader;

public class SandboxSecurityPolicy
extends Policy {
    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (this.isPlugin(domain)) {
            return this.pluginPermissions();
        }
        return this.applicationPermissions();
    }

    private boolean isPlugin(ProtectionDomain domain) {
        return domain.getClassLoader() instanceof PluginClassLoader;
    }

    private PermissionCollection pluginPermissions() {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return permissions;
    }

    private PermissionCollection applicationPermissions() {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        permissions.add(new ReflectPermission("suppressAccessChecks"));
        permissions.add(new RuntimePermission("accessClassInPackage.sun.reflect", "read,write"));
        return permissions;
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (permission instanceof RuntimePermission) {
            if (this.isPlugin(domain)) {
                return !permission.getName().startsWith("exitVM");
            }
            return true;
        }
        return true;
    }
}

