/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tech.spring.processor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.tech.base.pubsub.anno.Topic;
import com.xforceplus.tech.spring.pubsub.PubSubRuntime;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class PubSubBeanProcessor
implements BeanPostProcessor {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final EmbeddedValueResolver embeddedValueResolver;

    public PubSubBeanProcessor(ConfigurableBeanFactory beanFactory) {
        this.embeddedValueResolver = new EmbeddedValueResolver(beanFactory);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean == null) {
            return null;
        }
        PubSubBeanProcessor.subscribeToTopics(bean.getClass(), this.embeddedValueResolver);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private static void subscribeToTopics(Class clazz, EmbeddedValueResolver embeddedValueResolver) {
        if (clazz == null) {
            return;
        }
        PubSubBeanProcessor.subscribeToTopics(clazz.getSuperclass(), embeddedValueResolver);
        for (Method method : clazz.getDeclaredMethods()) {
            Topic topic = method.getAnnotation(Topic.class);
            if (topic == null) continue;
            String topicName = embeddedValueResolver.resolveStringValue(topic.name());
            String pubSubName = embeddedValueResolver.resolveStringValue(topic.pubsubName());
            if (topicName == null || topicName.length() <= 0 || pubSubName == null || pubSubName.length() <= 0) continue;
            try {
                TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
                Map metadata = (Map)MAPPER.readValue(topic.metadata(), (TypeReference)typeRef);
                List<String> routes = PubSubBeanProcessor.getAllCompleteRoutesForPost(clazz, method, topicName);
                for (String route : routes) {
                    PubSubRuntime.getInstance().addSubscribedTopic(pubSubName, topicName, route, metadata);
                }
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Error while parsing metadata: " + e.toString());
            }
        }
    }

    private static List<String> getAllCompleteRoutesForPost(Class clazz, Method method, String topicName) {
        String[] postValueArray;
        ArrayList<String> routesList = new ArrayList<String>();
        RequestMapping clazzRequestMapping = clazz.getAnnotation(RequestMapping.class);
        String[] clazzLevelRoute = null;
        if (clazzRequestMapping != null) {
            clazzLevelRoute = clazzRequestMapping.value();
        }
        if ((postValueArray = PubSubBeanProcessor.getRoutesForPost(method, topicName)) != null && postValueArray.length >= 1) {
            for (String postValue : postValueArray) {
                if (clazzLevelRoute != null && clazzLevelRoute.length >= 1) {
                    for (String clazzLevelValue : clazzLevelRoute) {
                        String route = clazzLevelValue + PubSubBeanProcessor.confirmLeadingSlash(postValue);
                        routesList.add(route);
                    }
                    continue;
                }
                routesList.add(postValue);
            }
        }
        return routesList;
    }

    private static String[] getRoutesForPost(Method method, String topicName) {
        String[] postValueArray;
        block4: {
            block2: {
                PostMapping postMapping;
                block3: {
                    postValueArray = new String[]{topicName};
                    postMapping = method.getAnnotation(PostMapping.class);
                    if (postMapping == null) break block2;
                    if (postMapping.path() == null || postMapping.path().length < 1) break block3;
                    postValueArray = postMapping.path();
                    break block4;
                }
                if (postMapping.value() == null || postMapping.value().length < 1) break block4;
                postValueArray = postMapping.value();
                break block4;
            }
            RequestMapping reqMapping = method.getAnnotation(RequestMapping.class);
            for (RequestMethod reqMethod : reqMapping.method()) {
                if (reqMethod != RequestMethod.POST) continue;
                if (reqMapping.path() != null && reqMapping.path().length >= 1) {
                    postValueArray = reqMapping.path();
                    break;
                }
                if (reqMapping.value() == null || reqMapping.value().length < 1) break;
                postValueArray = reqMapping.value();
                break;
            }
        }
        return postValueArray;
    }

    private static String confirmLeadingSlash(String path) {
        if (path != null && path.length() >= 1 && !path.substring(0, 1).equals("/")) {
            return "/" + path;
        }
        return path;
    }
}

