/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.xforceplus.phoenix.oss.DateTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssUploader {
    private static final String ORIGINAL_FILENAME = "filename";
    private static final Logger logger = LoggerFactory.getLogger(OssUploader.class);
    private OSSClient client = null;
    private String bucketName;

    public OssUploader(String protocol, String ossEndpoint, String accessId, String accessKey, String bucketName) {
        this.client = new OSSClient(protocol + "://" + ossEndpoint, accessId, accessKey);
        this.bucketName = bucketName;
    }

    public String uploadFile(String localFile) throws FileNotFoundException, RuntimeException {
        File file = new File(localFile);
        if (!file.exists()) {
            throw new FileNotFoundException("\u6587\u4ef6" + localFile + "\u672a\u627e\u5230");
        }
        String ext = file.getName().substring(file.getName().lastIndexOf("."));
        String key = "tmp/" + DateTool.today() + "/" + UUID.randomUUID().toString() + ext;
        FileInputStream content = new FileInputStream(file);
        ObjectMetadata meta = new ObjectMetadata();
        HashMap<String, String> userMetadata = new HashMap<String, String>();
        userMetadata.put(ORIGINAL_FILENAME, file.getName());
        meta.setContentLength(file.length());
        meta.setUserMetadata(userMetadata);
        PutObjectResult result = this.client.putObject(this.bucketName, key, (InputStream)content, meta);
        logger.info("\u4e0a\u4f20\u6587\u4ef6:{}\uff0c result:{}", (Object)localFile, (Object)result.getETag());
        return key;
    }
}

