/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.oss.service.impl;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.xforceplus.phoenix.oss.OSSSettings;
import com.xforceplus.phoenix.oss.model.FileTypeConfig;
import com.xforceplus.phoenix.oss.model.FileTypeSettings;
import com.xforceplus.phoenix.oss.model.OSSSignatureRequest;
import com.xforceplus.phoenix.oss.model.OSSSignatureResponse;
import com.xforceplus.phoenix.oss.model.OSSSignatureResponseResult;
import com.xforceplus.phoenix.oss.service.OssService;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.CommonTools;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OssServiceImpl
implements OssService {
    private static final Logger logger = LoggerFactory.getLogger(OssServiceImpl.class);
    private String accessId = "Z2nVA9OmlwdtWaD6";
    private String accessKey = "W4oMLiIn43APTVu6RfpBRtCMubug8a";
    private String ossEndpoint = "http://oss-cn-hangzhou.aliyuncs.com/";
    private String bucketName = "imsc-dvlp-files";
    private String host = "";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private long expireTime = 30L;
    @Autowired
    private OSSSettings ossSettings;
    @Autowired
    private FileTypeSettings fileTypeSettings;
    private OSSClient client = null;

    @PostConstruct
    public void init() {
        this.accessId = this.ossSettings.getAccessId();
        this.accessKey = this.ossSettings.getAccessKey();
        this.ossEndpoint = this.ossSettings.getOssEndpoint();
        this.bucketName = this.ossSettings.getBucketName();
        this.client = new OSSClient(this.ossEndpoint, this.accessId, this.accessKey);
        this.expireTime = Integer.valueOf(this.ossSettings.getSignatureExpireTime()).intValue();
        this.host = CommonTools.format((String)"http://{}.{}", (Object[])new Object[]{this.bucketName, this.ossEndpoint});
    }

    @Override
    public OSSSignatureResponse generateSignature(OSSSignatureRequest ossSignatureRequest) {
        OSSSignatureResponse response = new OSSSignatureResponse();
        if (ossSignatureRequest == null || CommonTools.isEmpty((String)ossSignatureRequest.getFunctionPoint())) {
            response.setCode(Response.Fail);
            response.setMessage("\u8bf7\u8f93\u5165\u529f\u80fd\u70b9\u540d\u79f0");
            return response;
        }
        try {
            String fileDirectory;
            FileTypeConfig fileTypeConfig;
            String functionPoint = ossSignatureRequest.getFunctionPoint();
            Map<String, FileTypeConfig> fileTypeMap = this.fileTypeSettings.getFileTypeMap();
            if (fileTypeMap.containsKey(functionPoint)) {
                fileTypeConfig = fileTypeMap.get(functionPoint);
                logger.info("{}", (Object)fileTypeConfig);
                if (CommonTools.isEmpty((String)fileTypeConfig.getModuleName())) {
                    response.setCode(Response.Fail);
                    response.setMessage("\u8bf7\u8054\u7cfb\u540e\u7aef\u5f00\u53d1\u914d\u7f6e\u529f\u80fd\u6240\u5c5e\u6a21\u5757");
                    return response;
                }
                fileDirectory = !CommonTools.isEmpty((String)fileTypeConfig.getDirectory()) ? fileTypeConfig.getDirectory() + "/" : "tmp/";
                if (fileTypeConfig.isDay()) {
                    fileDirectory = CommonTools.format((String)"{}{}", (Object[])new Object[]{fileDirectory, OssServiceImpl.today()});
                }
            } else {
                response.setCode(Response.Fail);
                response.setMessage("\u8bf7\u8054\u7cfb\u540e\u7aef\u5f00\u53d1\u914d\u7f6e\u529f\u80fd\u70b9\u76f8\u5173\u53c2\u6570");
                return response;
            }
            fileDirectory = fileTypeConfig.isPerpetual() ? CommonTools.format((String)"{}/{}/{}/", (Object[])new Object[]{"perpetual", fileTypeConfig.getModuleName(), fileDirectory}) : CommonTools.format((String)"{}/{}/{}/", (Object[])new Object[]{"temp", fileTypeConfig.getModuleName(), fileDirectory});
            String businessInterfaceUrl = fileTypeConfig.getBusinessInterfaceUrl();
            String fileBaseUrl = fileTypeConfig.getFileBaseUrl();
            long expireEndTime = System.currentTimeMillis() + this.expireTime * 1000L;
            Date expiration = new Date(expireEndTime);
            PolicyConditions policyConditions = new PolicyConditions();
            policyConditions.addConditionItem("content-length-range", 0L, 1048576000L);
            policyConditions.addConditionItem(MatchMode.StartWith, "key", fileDirectory);
            String postPolicy = this.client.generatePostPolicy(expiration, policyConditions);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = this.client.calculatePostSignature(postPolicy);
            logger.info("policy:{}", (Object)encodedPolicy);
            logger.info("postSignature:{}", (Object)postSignature);
            OSSSignatureResponseResult responseResult = new OSSSignatureResponseResult();
            responseResult.setAccessId(this.accessId);
            responseResult.setExpire(String.valueOf(expireEndTime / 1000L));
            responseResult.setHost(this.host);
            responseResult.setPolicy(encodedPolicy);
            responseResult.setSignature(postSignature);
            responseResult.setFileDirectory(fileDirectory);
            responseResult.setBusinessInterfaceUrl(businessInterfaceUrl);
            responseResult.setFileBaseUrl(fileBaseUrl);
            response.setResult(responseResult);
            response.setCode(Response.OK);
            response.setMessage("\u83b7\u53d6\u7b7e\u540d\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            response.setCode(Response.Fail);
            response.setMessage("\u83b7\u53d6\u7b7e\u540d\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458");
        }
        return response;
    }

    private static String today() {
        Date date = new Date();
        return sdf.format(date);
    }
}

