/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenantsecurity.interceptor;

import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import com.xforceplus.tenantsecurity.domain.UserInfoHolder;
import com.xforceplus.tenantsecurity.utils.CompressionUtils;
import com.xforceplus.tenantsecurity.utils.JsonUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroServiceFeignInterceptor
implements RequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(MicroServiceFeignInterceptor.class);

    public void apply(RequestTemplate requestTemplate) {
        IAuthorizedUser userInfo = UserInfoHolder.get();
        if (userInfo != null) {
            try {
                String value = CompressionUtils.encode((String)JsonUtils.toJson((Object)userInfo));
                requestTemplate.header("x-userinfo", new String[]{value});
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

