/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenantsecurity.interceptor;

import com.xforceplus.tenantsecurity.annotation.SkipAuth;
import com.xforceplus.tenantsecurity.domain.AuthorizedUser;
import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import com.xforceplus.tenantsecurity.domain.UserInfoHolder;
import com.xforceplus.tenantsecurity.utils.CompressionUtils;
import com.xforceplus.tenantsecurity.utils.JsonUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class UserContextInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(UserContextInterceptor.class);
    @Value(value="${xforce.tenant_security.starter.interceptors.default_user_info:}")
    private String defaultUserInfoJson;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (handler instanceof ResourceHttpRequestHandler) {
            return true;
        }
        String user = request.getHeader("x-userinfo");
        if (StringUtils.isEmpty((CharSequence)user)) {
            HandlerMethod method = (HandlerMethod)handler;
            boolean isSkipAuth = method.hasMethodAnnotation(SkipAuth.class);
            if (!isSkipAuth || StringUtils.isEmpty((CharSequence)this.defaultUserInfoJson)) {
                return true;
            }
            user = this.defaultUserInfoJson;
        } else {
            user = CompressionUtils.decode((String)user);
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)user)) {
                IAuthorizedUser userInfo = (IAuthorizedUser)JsonUtils.fromJson((String)user, AuthorizedUser.class);
                UserInfoHolder.put((IAuthorizedUser)userInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u7528\u6237\u4e0a\u4e0b\u6587\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        UserInfoHolder.clearContext();
    }
}

