/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.org;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.domain.org.OrgDto;
import java.util.List;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface OrgApi {
    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<Page<T>> page(@SpringQueryMap OrgModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs"}, method={RequestMethod.POST})
    public <T extends OrgDto<T>> ResponseEntity<T> create(@Valid @RequestBody OrgModel.Request.Save var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}"}, method={RequestMethod.PUT})
    public <T extends OrgDto<T>> ResponseEntity<T> update(@PathVariable(value="orgId") long var1, @RequestBody OrgModel.Request.Save var3);

    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<T> info(@PathVariable(value="orgId") long var1, @RequestParam(value="extraInfo", required=false, defaultValue="0") int var3);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="orgId") long var1);

    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u5b50\u5b59", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}/descendants"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<List<T>> descendants(@PathVariable(value="orgId") long var1);

    public static interface Path
    extends Uri {
        public static final String page = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs";
        public static final String create = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs";
        public static final String update = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}";
        public static final String info = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}";
        public static final String delete = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}";
        public static final String descendants = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}/descendants";
    }
}

