/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.user;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.user.RoleDto;
import com.xforceplus.domain.user.UserDto;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface UserApi {
    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users"}, method={RequestMethod.GET})
    public <T extends UserDto<O, R>, O extends OrgDto<O>, R extends RoleDto> ResponseEntity<Page<T>> page(@SpringQueryMap UserModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users"}, method={RequestMethod.POST})
    public <T extends UserDto<O, R>, O extends OrgDto<O>, R extends RoleDto> ResponseEntity<T> create(@RequestBody UserModel.Request.Save var1);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/user-batch"}, method={RequestMethod.POST})
    public <T, O extends OrgDto<O>, R extends RoleDto> ResponseEntity<T> createBatch(@RequestBody List<UserModel.Request.BatchSave> var1);

    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}"}, method={RequestMethod.GET})
    public <T extends UserDto<O, R>, O extends OrgDto<O>, R extends RoleDto> ResponseEntity<T> info(@PathVariable(value="userId") long var1, @RequestParam(value="extraInfo", required=false, defaultValue="0") int var3);

    @ResponseBody
    @RequestMapping(name="\u6839\u636e\u7528\u6237\u540d\u83b7\u53d6\u7528\u6237\u8be6\u60c5", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/info"}, method={RequestMethod.GET})
    public <T extends UserDto<O, R>, O extends OrgDto<O>, R extends RoleDto> ResponseEntity<T> user_info(@RequestParam(value="username") String var1, @RequestParam(value="extraInfo", required=false, defaultValue="0") int var2);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}"}, method={RequestMethod.PUT})
    public <T extends UserDto<O, R>, O extends OrgDto<O>, R extends RoleDto> ResponseEntity<T> update(@PathVariable(value="userId") long var1, @RequestBody UserModel.Request.Save var3);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="userId") long var1);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7684\u7ec4\u7ec7\u6811", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/orgs"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<T> userOrgs(@PathVariable(value="userId") long var1);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7684\u8d44\u6e90\u7801\u96c6\u5408", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/resources"}, method={RequestMethod.GET})
    public ResponseEntity<Set<String>> userResources(@PathVariable(value="userId") long var1);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ed1\u5b9a\u89d2\u8272\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/roles"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindRoles(@PathVariable(value="userId") long var1, @RequestBody List<Long> var3);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ed1\u5b9a\u89d2\u8272\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/roles"}, method={RequestMethod.POST})
    public <T extends UserModel.Request.BindRole> ResponseEntity<List<T>> bindUsersAndRoles(@Valid @RequestBody List<UserModel.Request.BindRole> var1);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ed1\u5b9a\u7ec4\u7ec7\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/orgs"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindOrgs(@PathVariable(value="userId") long var1, @RequestBody List<Long> var3);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ec4\u7ec7\u7ed1\u5b9a", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/user/org/bind"}, method={RequestMethod.POST})
    public ResponseEntity<List<UserModel.Request.BindOrg>> bindUserAndOrg(@RequestBody List<UserModel.Request.BindOrg> var1);

    public static interface Path
    extends Uri {
        public static final String page = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users";
        public static final String list = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/list";
        public static final String create = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users";
        public static final String createBatch = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/user-batch";
        public static final String update = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}";
        public static final String info = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}";
        public static final String user_info = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/info";
        public static final String delete = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}";
        public static final String orgs = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/orgs";
        public static final String resources = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/resources";
        public static final String userOrgBind = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/user/org/bind";
        public static final String users_bind_roles = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/roles";
        public static final String user_bind_roles = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/roles";
        public static final String user_bind_orgs = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/orgs";
    }
}

