/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.account;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.AccountModel;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.domain.user.UserDto;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface AccountApi {
    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/login"}, method={RequestMethod.GET})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> login(@SpringQueryMap @Valid AccountModel.Request.Login var1, @RequestParam(value="extraInfo", required=false, defaultValue="0") int var2);

    @ResponseBody
    @RequestMapping(name="\u8d26\u6237\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts"}, method={RequestMethod.GET})
    public <A extends AccountDto> ResponseEntity<Page<A>> page(@SpringQueryMap AccountModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u8d26\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts"}, method={RequestMethod.POST})
    public <A extends AccountDto> ResponseEntity<A> create(@RequestBody @Valid AccountModel.Request.Save var1);

    @ResponseBody
    @RequestMapping(name="\u6ce8\u518c\u8d26\u53f7", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/register"}, method={RequestMethod.POST})
    public ResponseEntity<String> register(@RequestBody @Valid AccountModel.Request.Regist var1);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u8d26\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/batch"}, method={RequestMethod.POST})
    public <T extends AccountDto> ResponseEntity<List<T>> createBatch(@RequestBody @Valid @Valid List<// Could not load outer class - annotation placement on inner may be incorrect
     @Valid AccountModel.Request.Save> var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u8d26\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}"}, method={RequestMethod.PUT})
    public <T extends AccountDto> ResponseEntity<T> update(@PathVariable(value="accountId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody @Valid AccountModel.Request.Save var3);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u8d26\u6237\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="accountId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3);

    @ResponseBody
    @RequestMapping(name="\u9501\u5b9a\u8d26\u53f7", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/lock"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> accountLock(@PathVariable(value="accountId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u8d26\u53f7\u89e3\u9501", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/unlock"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> accountUnlock(@PathVariable(value="accountId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u6839\u636eid\u83b7\u53d6\u5e10\u53f7\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}"}, method={RequestMethod.GET})
    public <T extends AccountDto> ResponseEntity<T> info(@PathVariable(value="accountId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u6839\u636e\u767b\u5f55\u7528\u6237\u540d\u66f4\u6539\u8d26\u6237\u5bc6\u7801", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/password"}, method={RequestMethod.PUT})
    public ResponseEntity<String> updatePassword(@RequestBody @Valid AccountModel.Request.ChangePassword var1);

    @ResponseBody
    @RequestMapping(name="\u6839\u636eaccountId\u66f4\u6539\u8d26\u6237\u5bc6\u7801", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/password"}, method={RequestMethod.PUT})
    public ResponseEntity<String> updatePasswordByAccountId(@PathVariable(value="accountId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody @Valid AccountModel.Request.ChangePasswordById var3);

    @ResponseBody
    @RequestMapping(name="\u9a8c\u8bc1\u5bc6\u7801", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/password"}, method={RequestMethod.GET})
    public ResponseEntity<String> checkPassword(@SpringQueryMap @Valid AccountModel.Request.CheckPassword var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u6362\u624b\u673a\u53f7\u53d1\u77ed\u4fe1", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/phone/code"}, method={RequestMethod.GET})
    public ResponseEntity<String> sendChangePhoneCode(@RequestParam(value="phone") String var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u6362\u90ae\u7bb1\u53d1\u77ed\u4fe1", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/email/code"}, method={RequestMethod.GET})
    public ResponseEntity<String> sendChangeEmailCode(@RequestParam(value="email") String var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u6362\u624b\u673a\u53f7", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/phone"}, method={RequestMethod.PUT})
    public ResponseEntity<String> changePhone(@RequestBody @Valid AccountModel.Request.ChangePhone var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u6362\u624b\u90ae\u7bb1", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/email"}, method={RequestMethod.PUT})
    public ResponseEntity<String> changeEmail(@RequestBody @Valid AccountModel.Request.ChangeEmail var1);

    @ResponseBody
    @RequestMapping(name="\u7ed1\u5b9a\u624b\u673a\u53f7", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/phone/bind"}, method={RequestMethod.PUT})
    public ResponseEntity<String> bindPhone(@RequestBody @Valid AccountModel.Request.BindPhone var1);

    @ResponseBody
    @RequestMapping(name="\u7ed1\u5b9a\u90ae\u7bb1", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/email/bind"}, method={RequestMethod.PUT})
    public ResponseEntity<String> bindEmail(@RequestBody @Valid AccountModel.Request.BindEmail var1);

    @ResponseBody
    @RequestMapping(name="\u53d1\u9001\u90ae\u4ef6\u6216\u8005\u77ed\u4fe1\u9a8c\u8bc1\u7801", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/valid/code"}, method={RequestMethod.POST})
    public ResponseEntity<String> sendValidCode(@RequestParam(value="username") @Valid @NotBlank(message="username\u4e0d\u80fd\u4e3a\u7a7a") @Valid @NotBlank(message="username\u4e0d\u80fd\u4e3a\u7a7a") String var1);

    @ResponseBody
    @RequestMapping(name="\u4fee\u6539\u5bc6\u7801\uff08\u624b\u673a\u53f7/\u90ae\u7bb1\uff09", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/pwd"}, method={RequestMethod.POST})
    public ResponseEntity<String> updatePwd(@RequestBody @Valid AccountModel.ChangePwd var1);

    @ResponseBody
    @RequestMapping(name="\u89e3\u7ed1\u624b\u673a\u53f7", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/phone/unbind"}, method={RequestMethod.PUT})
    public ResponseEntity<String> unBindPhone(@RequestBody @Valid AccountModel.Request.UnBindPhone var1);

    @ResponseBody
    @RequestMapping(name="\u89e3\u7ed1\u90ae\u7bb1", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/email/unbind"}, method={RequestMethod.PUT})
    public ResponseEntity<String> unBindEmail(@RequestBody @Valid AccountModel.Request.UnBindEmail var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u6362\u79df\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/tenants/{tenantId}/change"}, method={RequestMethod.GET})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> changeTenant(@PathVariable(value="accountId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @PathVariable(value="tenantId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var3);

    @ResponseBody
    @RequestMapping(name="\u4fee\u6539\u6700\u540e\u4e00\u6b21\u767b\u5f55\u65f6\u95f4", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/last-login-time/{accountId}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateLastLoginTime(@PathVariable(value="accountId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u8d26\u6237\u67e5\u8be2", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/username/{username}"}, method={RequestMethod.GET})
    public <A extends AccountDto> ResponseEntity<A> queryByUsername(@PathVariable(value="username") String var1);

    @ResponseBody
    @RequestMapping(name="\u67e5\u8be2\u5e10\u53f7\u52a0\u5bc6\u5bc6\u7801", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/pwd/{accountId}"}, method={RequestMethod.GET})
    public ResponseEntity<String> getEncryptPassword(@PathVariable(value="accountId") @Valid @Min(value=1L) @Valid @Min(value=1L) Long var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u8d26\u6237\u4e8c\u6b21\u8ba4\u8bc1\u72b6\u6001 ", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/doubleAuth"}, method={RequestMethod.PUT})
    public ResponseEntity<String> updateDoubleAuth(@PathVariable(value="accountId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="status") boolean var3);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u8d26\u6237 \u7ed1\u5b9a\u90ae\u7bb1\u6216\u624b\u673a\u53f7\u7684\u5f00\u5173 ", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/bindAuth"}, method={RequestMethod.PUT})
    public ResponseEntity<String> updateBindAuth(@PathVariable(value="accountId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="status") boolean var3);

    @ResponseBody
    @RequestMapping(name="\u534e\u6da6\u540c\u6b65\u670d\u52a1\u4fee\u6539\u5bc6\u7801\uff08\u5df2\u7ecf\u52a0\u5bc6\u597d\u7684\u5bc6\u6587\uff09", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/password/ciphertxt"}, method={RequestMethod.PUT})
    public ResponseEntity<String> updatePasswordCiphertext(@RequestBody @Valid AccountModel.Request.UpdatePasswordCiphertext var1);

    @ResponseBody
    @RequestMapping(name="\u6839\u636e\u5e10\u53f7 ID \u83b7\u53d6\u8be5\u5e10\u53f7\u4f5c\u4e3a\u79df\u6237\u7ba1\u7406\u5458\u7684\u6240\u6709\u79df\u6237\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{account}/tenants"}, method={RequestMethod.GET})
    public <T extends TenantDto> ResponseEntity<List<T>> getTenantListByAccount(@PathVariable(value="account") String var1, @RequestParam(name="account", required=false) Boolean var2);

    public static interface Path
    extends Uri {
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts";
        public static final String QUERY_BY_USERNAME = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/username/{username}";
        public static final String CREATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts";
        public static final String REGISTER = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/register";
        public static final String BATCH_CREATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/batch";
        public static final String UPDATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}";
        public static final String UPDATE_STATUS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/status/{status}";
        public static final String ACCOUNT_LOCK = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/lock";
        public static final String ACCOUNT_UNLOCK = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/unlock";
        public static final String ACCOUNT_USER_LIST = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/users";
        public static final String LOGIN = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/login";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}";
        public static final String DELETE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}";
        public static final String UPDATE_PASSWORD = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/password";
        public static final String UPDATE_PASSWORD_CIPHERTEXT = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/password/ciphertxt";
        public static final String UPDATE_PASSWORD_BY_ACCOUNTID = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/password";
        public static final String CHECK_PASSWORD = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/password";
        public static final String CHANGE_PHONE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/phone";
        public static final String CHANGE_EMAIL = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/email";
        public static final String SEND_VALID_CODE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/valid/code";
        public static final String UPDATE_PWD = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/pwd";
        public static final String SEND_CHANGE_PHONE_CODE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/phone/code";
        public static final String SEND_CHANGE_EMAIL_CODE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/email/code";
        public static final String BIND_PHONE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/phone/bind";
        public static final String BIND_EMAIL = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/email/bind";
        public static final String CHANGE_TENANT = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/tenants/{tenantId}/change";
        public static final String UN_BIND_PHONE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/phone/unbind";
        public static final String UN_BIND_EMAIL = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/email/unbind";
        public static final String UPDATE_LAST_LOGIN_TIME = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/last-login-time/{accountId}";
        public static final String GET_ENCRYPT_PASSWORD = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/pwd/{accountId}";
        public static final String ACCOUNT_DOUBLE_AUTH = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/doubleAuth";
        public static final String ACCOUNT_BIND_AUTH = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/bindAuth";
        public static final String GET_ADMIN_TENANTS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{account}/tenants";
    }
}

