/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.company;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.domain.company.CompanyPackage;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.validation.ValidationGroup;
import io.geewit.data.jpa.envers.domain.ComparedRevision;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface CompanyApi {
    @ResponseBody
    @RequestMapping(name="\u516c\u53f8\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies"}, method={RequestMethod.GET})
    public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<Page<C>> page(@SpringQueryMap CompanyModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u516c\u53f8\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyKey}"}, method={RequestMethod.GET})
    public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<C> info(@PathVariable(value="companyKey") String var1, @RequestParam(value="byTaxNum", required=false, defaultValue="false") boolean var2, @RequestParam(value="revisionDate", required=false) Date var3, @RequestParam(value="withExtendParams", required=false) String var4);

    default public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<C> info(long companyId, Date revisionDate, String withExtendParams) {
        return this.info(String.valueOf(companyId), false, revisionDate, withExtendParams);
    }

    @ResponseBody
    @RequestMapping(name="\u7a0e\u53f7\u67e5\u8be2\u516c\u53f8\u4fe1\u606f,\u652f\u6301\u6269\u5c55\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/taxNum"}, method={RequestMethod.GET})
    public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<C> infoByTaxNum(@RequestParam(value="taxNum", required=true) String var1, @RequestParam(value="withExtendParams", required=false) String var2);

    @ResponseBody
    @RequestMapping(name="\u67e5\u6307\u5b9a\u516c\u53f8\u53d8\u66f4\u5386\u53f2\u5206\u9875\u8bb0\u5f55", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyKey}/histories"}, method={RequestMethod.GET})
    public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<Page<ComparedRevision<C, String>>> histories(@PathVariable(value="companyKey") String var1, @RequestParam(value="byTaxNum", required=false, defaultValue="false") boolean var2, Pageable var3);

    default public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<Page<ComparedRevision<C, String>>> histories(long companyId, Pageable pageable) {
        return this.histories(String.valueOf(companyId), false, pageable);
    }

    @ResponseBody
    @RequestMapping(name="\u67e5\u6307\u5b9a\u516c\u53f8\u53d8\u66f4\u5386\u53f2\u5206\u9875\u8bb0\u5f55", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyKey}/histories/{revision}"}, method={RequestMethod.PUT})
    public ResponseEntity<String> updateRevisionEffective(@PathVariable(value="companyKey") String var1, @RequestParam(value="byTaxNum", required=false, defaultValue="false") boolean var2, @PathVariable(value="revision") @Valid @Min(value=1L) @Valid @Min(value=1L) long var3, @RequestParam(value="effective", defaultValue="true") Boolean var5);

    default public ResponseEntity<String> updateRevisionEffective(long companyId, long revision, Boolean effective) {
        return this.updateRevisionEffective(String.valueOf(companyId), false, revision, effective);
    }

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u516c\u53f8", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyKey}"}, method={RequestMethod.PUT})
    public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<C> update(@PathVariable(value="companyKey") String var1, @RequestParam(value="byTaxNum", required=false, defaultValue="false") boolean var2, @RequestBody @Validated(value={ValidationGroup.OnUpdate.class}) CompanyModel.Request.Save var3);

    default public <C extends CompanyDto<O>, O extends OrgDto<O>> ResponseEntity<C> update(long companyId, CompanyModel.Request.Save model) {
        return this.update(String.valueOf(companyId), false, model);
    }

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u516c\u53f8\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyKey}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="companyKey") String var1, @RequestParam(value="byTaxNum", required=false, defaultValue="false") boolean var2, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3);

    default public ResponseEntity<String> updateStatus(long companyId, int status) {
        return this.updateStatus(String.valueOf(companyId), false, status);
    }

    @ResponseBody
    @RequestMapping(name="\u516c\u53f8\u670d\u52a1\u5305\u5206\u9875\u67e5\u8be2", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/packages"}, method={RequestMethod.GET})
    public ResponseEntity<Page<CompanyPackage>> packages(@SpringQueryMap CompanyModel.Request.CompanyPackageQuery var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u5224\u65ad\u662f\u5426\u5386\u53f2\u4e0a\u5b58\u5728\u8be5\u516c\u53f8\u540d\u53ca\u7a0e\u53f7", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/history/exist"}, method={RequestMethod.GET})
    public ResponseEntity<Boolean> existInHistory(@RequestParam(value="taxNum") String var1, @RequestParam(value="companyName") String var2, @RequestParam(value="effectiveDate", required=false) Date var3);

    @ResponseBody
    @ApiOperation(value="\u79fb\u52a8\u516c\u53f8")
    @RequestMapping(name="\u79fb\u52a8\u516c\u53f8", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyId}/move"}, method={RequestMethod.PATCH})
    public ResponseEntity<Map<String, Object>> move(@PathVariable(value="companyId") Long var1, @RequestBody @Valid CompanyModel.Request.Move var2);

    @ResponseBody
    @ApiOperation(value="\u79fb\u52a8\u516c\u53f8")
    @RequestMapping(name="\u79fb\u52a8\u516c\u53f8", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyId}/moveall"}, method={RequestMethod.PATCH})
    public ResponseEntity<Map<String, Object>> moveAll(@PathVariable(value="companyId") Long var1, @RequestBody @Valid CompanyModel.Request.Move var2);

    @ResponseBody
    @RequestMapping(name="\u516c\u53f8\u5173\u8054\u79df\u6237\u8be6\u60c5\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyKey}/tenant-rels"}, method={RequestMethod.GET})
    public ResponseEntity<CompanyModel.Response.CompanyInfo> tenantRels(@PathVariable(value="companyKey") String var1, @RequestParam(value="byTaxNum", required=false, defaultValue="false") boolean var2);

    default public ResponseEntity<CompanyModel.Response.CompanyInfo> tenantRels(long companyId) {
        return this.tenantRels(String.valueOf(companyId), false);
    }

    @ResponseBody
    @ApiOperation(value="\u8bbe\u7f6ehostTenant")
    @RequestMapping(name="\u8bbe\u7f6ehostTenant", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyId}/host-tenant/{tenantId}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> changeHostTenant(@PathVariable(value="companyId") Long var1, @PathVariable(value="tenantId") Long var2);

    @ResponseBody
    @ApiOperation(value="\u516c\u53f8\u79fb\u9664\u79df\u6237")
    @RequestMapping(name="\u516c\u53f8\u79fb\u9664\u79df\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyId}/remove-tenant/{tenantId}"}, method={RequestMethod.PUT})
    public ResponseEntity<String> removeTenant(@PathVariable(value="companyId") Long var1, @PathVariable(value="tenantId") Long var2);

    public static interface Path
    extends Uri {
        public static final String API_PREFIX = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies";
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies";
        public static final String LIST = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/list";
        public static final String UPDATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyKey}";
        public static final String UPDATE_STATUS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyKey}/status/{status}";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyKey}";
        public static final String INFO_BY_TAXNUM = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/taxNum";
        public static final String HISTORIES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyKey}/histories";
        public static final String UPDATE_REVISION_EFFECTIVE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyKey}/histories/{revision}";
        public static final String DELETE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyKey}";
        public static final String EXIST_IN_HISTORY = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/history/exist";
        public static final String PAGE_COMPANY_PACKAGES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/packages";
        public static final String BATCH_IMPORT = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/import";
        public static final String BATCH_ASNYC_IMPORT = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/asnyc/import";
        public static final String BATCH_EXPORT = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/export";
        public static final String BATCH_IMPORT_CONFIGURATION = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/configuration/import";
        public static final String BATCH_ASNYC_IMPORT_CONFIGURATION = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/asnyc/configuration/import";
        public static final String BATCH_EXPORT_CONFIGURATION = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/configuration/export";
        public static final String FIX_COMPANIES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/fix";
        public static final String BATCH_IMPORT_UPDATE_COMPANY = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/name-tax-num/import";
        public static final String MOVE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyId}/move";
        public static final String MOVE_ALL = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyId}/moveall";
        public static final String TENANT_RELS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyKey}/tenant-rels";
        public static final String HOST_TENANT = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyId}/host-tenant/{tenantId}";
        public static final String REMOVE_TENANT = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/{companyId}/remove-tenant/{tenantId}";
        public static final String TAXWARE_CALLBACK = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/callback";
    }
}

