/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.company;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.CompanyApplyModel;
import com.xforceplus.domain.company.CompanyDto;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface CompanyApplyApi {
    @ResponseBody
    @RequestMapping(name="\u516c\u53f8\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/applications"}, method={RequestMethod.GET})
    public <T extends CompanyDto> ResponseEntity<Page<T>> page(@SpringQueryMap CompanyApplyModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u516c\u53f8\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/applications/{applicationId}"}, method={RequestMethod.GET})
    public <T extends CompanyDto> ResponseEntity<T> info(@PathVariable(value="applicationId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u5ba1\u6838\u901a\u8fc7", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/applications/{applicationId}/approve"}, method={RequestMethod.PUT})
    public ResponseEntity<String> approve(@PathVariable(value="applicationId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="reason", required=false) String var3);

    @ResponseBody
    @RequestMapping(name="\u5ba1\u6838\u9a73\u56de", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/applications/{applicationId}/decline"}, method={RequestMethod.PUT})
    public ResponseEntity<String> decline(@PathVariable(value="applicationId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="reason", required=false) String var3);

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5ba1\u6838\u901a\u8fc7", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/applications/approve"}, method={RequestMethod.PUT})
    public ResponseEntity<CompanyApplyModel.Response.ApplicationProcessResult> batchApprove(@RequestBody CompanyApplyModel.Request.ApplicationProcess var1);

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5ba1\u6838\u9a73\u56de", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/applications/decline"}, method={RequestMethod.PUT})
    public ResponseEntity<CompanyApplyModel.Response.ApplicationProcessResult> batchDecline(@RequestBody CompanyApplyModel.Request.ApplicationProcess var1);

    public static interface Path
    extends Uri {
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/applications";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/applications/{applicationId}";
        public static final String APPROVE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/applications/{applicationId}/approve";
        public static final String DECLINE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/applications/{applicationId}/decline";
        public static final String BATCH_APPROVE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/applications/approve";
        public static final String BATCH_DECLINE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/applications/decline";
    }
}

