/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.org;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.OrgExtensionModel;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.api.model.org.OrgCompanyNoModel;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.org.OrgExtensionDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.domain.validation.ValidationGroup;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface OrgApi {
    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<Page<O>> page(@SpringQueryMap OrgModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs"}, method={RequestMethod.POST})
    public <O extends OrgDto<O>> ResponseEntity<O> create(@RequestBody OrgModel.Request.Save var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}"}, method={RequestMethod.PUT})
    public <O extends OrgDto<O>> ResponseEntity<O> update(@PathVariable(value="orgId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody @Validated(value={ValidationGroup.OnUpdate.class}) OrgModel.Request.Save var3);

    @ResponseBody
    @RequestMapping(name="\u4fee\u6539\u7ec4\u7ec7\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="orgId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3);

    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<O> info(@PathVariable(value="orgId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="extraInfo", required=false, defaultValue="0") int var3);

    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u7528\u6237\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}/users"}, method={RequestMethod.GET})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<Page<U>> users(@PathVariable(value="orgId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, Pageable var3);

    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u5b50\u8282\u70b9", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}/children"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<List<O>> children(@PathVariable(value="orgId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="userId", required=false) @Valid @Min(value=1L) @Valid @Min(value=1L) Long var3, @RequestParam(value="withUserBoundFlag", required=false) Boolean var4);

    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u5b50\u5b59", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}/descendants"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<List<O>> descendants(@PathVariable(value="orgId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u6811", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/tree"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<O> globalTree(@SpringQueryMap OrgModel.Request.TreeQuery var1);

    @ResponseBody
    @RequestMapping(name="\u6839\u636e\u7a0e\u53f7\u67e5\u8be2\u79df\u6237\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/by-taxnum"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<List<O>> byTaxNum(@RequestParam(value="taxNum") String var1, @RequestParam(value="companyId", required=false) Long var2, @RequestParam(value="tenantId", required=false) Long var3, @RequestParam(value="orgId", required=false) Long var4, @RequestParam(value="tenantCode", required=false) String var5, @RequestParam(value="withHost", required=false, defaultValue="true") boolean var6, @RequestParam(value="hostTenantOnly", required=false) Boolean var7, @RequestParam(value="status", required=false) Integer var8);

    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u6269\u5c55\u5b57\u6bb5\u5206\u9875", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/extensions"}, method={RequestMethod.GET})
    public <E extends OrgExtensionDto> ResponseEntity<Page<E>> extensionsPage(@SpringQueryMap OrgExtensionModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u521b\u5efa\u7ec4\u7ec7\u6269\u5c55\u5b57\u6bb5", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}/extensions"}, method={RequestMethod.POST})
    public <E extends OrgExtensionDto> ResponseEntity<E> createExtension(@PathVariable(value="orgId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody OrgExtensionModel.Request.Create var3);

    @ResponseBody
    @RequestMapping(name="\u4fee\u6539\u7ec4\u7ec7\u6269\u5c55\u5b57\u6bb5", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/extensions/{extensionId}"}, method={RequestMethod.PUT})
    public <E extends OrgExtensionDto> ResponseEntity<E> updateExtension(@PathVariable(value="extensionId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody OrgExtensionModel.Request.Update var3);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u7ec4\u7ec7\u6269\u5c55\u5b57\u6bb5", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}/extensions"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteOrgExtensions(@PathVariable(value="orgId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u6269\u5c55\u5b57\u6bb5", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/extensions/{extensionId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteExtension(@PathVariable(value="extensionId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u6839\u636e\u7a0e\u53f7\u67e5\u8be2\u7ec4\u7ec7\u548c\u516c\u53f8", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/companies/taxnum"}, method={RequestMethod.GET})
    public ResponseEntity<List<OrgCompanyNoModel.Response>> orgCompaniesByTaxNum(@SpringQueryMap @Valid OrgCompanyNoModel.Request.Query var1);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="orgId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    public static interface Path
    extends Uri {
        public static final String API_PREFIX = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs";
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs";
        public static final String POST_PAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/orgs/postquery";
        public static final String CREATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs";
        public static final String UPDATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}";
        public static final String UPDATE_STATUS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}/status/{status}";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}";
        public static final String DELETE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}";
        public static final String USERS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}/users";
        public static final String CHILDREN = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}/children";
        public static final String DESCENDANTS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}/descendants";
        public static final String TREE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/tree";
        public static final String COMPANIES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/companies";
        public static final String BY_TAX_NUM = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/by-taxnum";
        public static final String CREATE_EXTENSION = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}/extensions";
        public static final String UPDATE_EXTENSION = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/extensions/{extensionId}";
        public static final String PAGE_EXTENSIONS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/extensions";
        public static final String DELETE_ORG_EXTENSIONS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/{orgId}/extensions";
        public static final String DELETE_EXTENSION = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/extensions/{extensionId}";
        public static final String ORG_COMPANIES_LIST = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/orgs/companies/taxnum";
    }
}

