/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.resource;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.ResourceModel;
import com.xforceplus.domain.resource.ResourceDto;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public interface ResourceApi {
    @ResponseBody
    @RequestMapping(name="\u8d44\u6e90\u7801\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources"}, method={RequestMethod.GET})
    public <T extends ResourceDto> ResponseEntity<Page<T>> page(@SpringQueryMap ResourceModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u8d44\u6e90\u7801", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources"}, method={RequestMethod.POST})
    public <T extends ResourceDto> ResponseEntity<T> create(@RequestBody ResourceModel.Request.Save var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u8d44\u6e90\u7801", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/{id}"}, method={RequestMethod.PUT})
    public <T extends ResourceDto> ResponseEntity<T> update(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody ResourceModel.Request.Save var3);

    @ResponseBody
    @RequestMapping(name="\u8d44\u6e90\u7801\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/{id}"}, method={RequestMethod.GET})
    public <T extends ResourceDto> ResponseEntity<T> info(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u8d44\u6e90\u7801", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u8d44\u6e90\u7801\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/{id}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3);

    @ResponseBody
    @RequestMapping(name="\u5728\u7236\u8d44\u6e90\u7801\u4e0b\u6dfb\u52a0\u8d44\u6e90\u7801", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/{id}/append"}, method={RequestMethod.POST})
    public <T extends ResourceDto> ResponseEntity<T> append(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody ResourceModel.Request.Save var3);

    @ResponseBody
    @RequestMapping(name="\u8d44\u6e90\u7801\u6279\u91cf\u7ed1\u5b9a\u63a5\u53e3", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/{id}/apis"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindApis(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody ResourceModel.Request.BindApis var3);

    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u7528\u6237\u8d44\u6e90\u7801", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/userRes"}, method={RequestMethod.POST})
    public ResponseEntity<List<ResourceDto>> getUserRoleResource(@RequestBody @Valid @Min(value=1L) @Valid @Min(value=1L) Long var1);

    public static interface Path
    extends Uri {
        public static final String DEFAULT_PATH = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources";
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources";
        public static final String LIST = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/list";
        public static final String CREATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources";
        public static final String UPDATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/{id}";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/{id}";
        public static final String DELETE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/{id}";
        public static final String APPEND = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/{id}/append";
        public static final String UPDATE_STATUS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/{id}/status/{status}";
        public static final String BIND_APIS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/{id}/apis";
        public static final String USER_RES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/userRes";
    }
}

