/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.resource;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.ServicePackageModel;
import com.xforceplus.domain.resource.ServicePackageDto;
import com.xforceplus.domain.validation.ValidationGroup;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface ServicePackageApi {
    @ResponseBody
    @RequestMapping(name="\u670d\u52a1\u5305\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages"}, method={RequestMethod.GET})
    public <T extends ServicePackageDto> ResponseEntity<Page<T>> page(@SpringQueryMap ServicePackageModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u670d\u52a1\u5305", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages"}, method={RequestMethod.POST})
    public <T extends ServicePackageDto> ResponseEntity<T> create(@RequestBody @Validated(value={ValidationGroup.OnCreate.class}) ServicePackageModel.Request.Save var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u670d\u52a1\u5305", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/{id}"}, method={RequestMethod.PUT})
    public <T extends ServicePackageDto> ResponseEntity<T> update(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody ServicePackageModel.Request.Save var3);

    @ResponseBody
    @RequestMapping(name="\u670d\u52a1\u5305\u8be6\u60c5", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/{id}"}, method={RequestMethod.GET})
    public <T extends ServicePackageDto> ResponseEntity<T> info(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u670d\u52a1\u5305", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u670d\u52a1\u5305\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/{id}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3);

    @ResponseBody
    @RequestMapping(name="\u9a8c\u8bc1\u6307\u5b9a\u670d\u52a1\u5305\u7684\u591a\u4e2a\u529f\u80fd\u96c6\u662f\u5426\u88ab\u89d2\u8272\u7ed1\u5b9a", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/{id}/resourcesets/validation"}, method={RequestMethod.GET})
    public ResponseEntity<Map<Long, Boolean>> validResourcesetsBound(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="resourcesetIds") String var3);

    public static interface Path
    extends Uri {
        public static final String API_PREFIX = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages";
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages";
        public static final String LIST = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/list";
        public static final String CREATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages";
        public static final String UPDATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/{id}";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/{id}";
        public static final String DELETE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/{id}";
        public static final String UPDATE_STATUS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/{id}/status/{status}";
        public static final String VALID_RESOURCESETS_WERE_BOUND = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/{id}/resourcesets/validation";
    }
}

