/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.tenant;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.TenantModel;
import com.xforceplus.api.model.TenantServiceRelModel;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.domain.resource.ServicePackageDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.domain.tenant.TenantPolicyDto;
import com.xforceplus.domain.tenant.TenantRelationDto;
import com.xforceplus.domain.tenant.TenantServicePackageDto;
import com.xforceplus.domain.user.UserDto;
import io.geewit.data.jpa.envers.domain.ComparedRevision;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface TenantApi {
    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants"}, method={RequestMethod.GET})
    public <T extends TenantDto> ResponseEntity<Page<T>> page(@SpringQueryMap TenantModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u79df\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants"}, method={RequestMethod.POST})
    public <T extends TenantDto, O extends OrgDto<O>, C extends CompanyDto<O>, U extends UserDto<O, R, A>, R extends RoleDto, A extends AccountDto> ResponseEntity<TenantModel.Response.CreateResult<T, O, C, U, R, A>> create(@RequestBody @Valid TenantModel.Request.Save var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u79df\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{id}"}, method={RequestMethod.PUT})
    public <T extends TenantDto> ResponseEntity<T> update(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody @Valid TenantModel.Request.Save var3);

    @ResponseBody
    @RequestMapping(name="\u67e5\u8be2\u79df\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{id}"}, method={RequestMethod.GET})
    public <T extends TenantDto> ResponseEntity<T> info(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="withExtendParams", required=false) String var3, @RequestParam(value="withManager", required=false) boolean var4);

    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u5df2\u5b58\u5728\u79df\u6237\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/exists"}, method={RequestMethod.GET})
    public <T extends TenantDto> ResponseEntity<T> exists(@RequestParam(value="tenantCode", required=false) String var1, @RequestParam(value="tenantName", required=false) String var2);

    @ResponseBody
    @RequestMapping(name="\u67e5\u8be2\u79df\u6237\u79c1\u94a5", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{id}/secret"}, method={RequestMethod.GET})
    public ResponseEntity<String> secret(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u67e5\u8be2\u6240\u6709\u79df\u6237\u79c1\u94a5", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/secrets"}, method={RequestMethod.GET})
    public ResponseEntity<Map<Long, String>> secrets();

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7684\u516c\u53f8\u670d\u52a1\u5305\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{id}/packages"}, method={RequestMethod.GET})
    public <T extends ServicePackageDto> ResponseEntity<Page<T>> servicePackages(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, Pageable var3);

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ed1\u5b9a\u516c\u53f8", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/companies/bind"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindCompanies(@PathVariable(value="tenantId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody List<Long> var3);

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ed1\u5b9a\u5355\u4e2a\u516c\u53f8", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/company/bind/{companyId}"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindCompany(@PathVariable(value="tenantId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @PathVariable(value="companyId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var3);

    @ResponseBody
    @RequestMapping(name="\u67e5\u8be2\u79df\u6237\u7b56\u7565", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{id}/policy"}, method={RequestMethod.GET})
    public <T extends TenantPolicyDto> ResponseEntity<Map<String, T>> policies(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u67e5\u8be2\u8ddf\u8fd9\u4e2a\u79df\u6237\u6709\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u7684\u79df\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/relation"}, method={RequestMethod.GET})
    public <T extends TenantRelationDto> ResponseEntity<List<T>> getTenantReleationByTenantId(@RequestParam(value="tenantId") @Valid @Min(value=1L) @Valid @Min(value=1L) Long var1);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u79df\u6237\u95f4\u7684\u5173\u7cfb", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/relation"}, method={RequestMethod.POST})
    public ResponseEntity<String> addTenantReleation(@RequestParam(value="parentTenantId", required=false) @Valid @Min(value=1L) @Valid @Min(value=1L) Long var1, @RequestParam(value="childTenantId", required=false) @Valid @Min(value=1L) @Valid @Min(value=1L) Long var2);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u79df\u6237\u95f4\u7684\u5173\u7cfb", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/relation"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteTenantReleation(@RequestParam(value="parentTenantId", required=false) @Valid @Min(value=1L) @Valid @Min(value=1L) Long var1, @RequestParam(value="childTenantId", required=false) @Valid @Min(value=1L) @Valid @Min(value=1L) Long var2);

    @ResponseBody
    @RequestMapping(name="\u67e5\u6307\u5b9a\u79df\u6237\u53d8\u66f4\u5386\u53f2\u5206\u9875\u8bb0\u5f55", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/histories"}, method={RequestMethod.GET})
    public <T extends TenantDto> ResponseEntity<Page<ComparedRevision<T, Long>>> histories(@PathVariable(value="tenantId") @Valid @Min(value=1L) @Valid @Min(value=1L) Long var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ed1\u5b9a\u4ea7\u54c1\u670d\u52a1\u5305", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/packages/bind"}, method={RequestMethod.POST})
    public ResponseEntity<String> tenantBindServicePackages(@PathVariable(value="tenantId") @Valid String var1, @RequestParam(value="byTenantCode", required=false) Boolean var2, @RequestBody @Valid TenantModel.Request.TenantBindPackages var3);

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u89e3\u7ed1\u4ea7\u54c1\u670d\u52a1\u5305", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/packages/unbind"}, method={RequestMethod.POST})
    public ResponseEntity<String> tenantUnbindServicePackages(@PathVariable(value="tenantId") @Valid String var1, @RequestParam(value="byTenantCode", required=false) Boolean var2, @RequestBody @Valid TenantModel.Request.ServicePackageList var3);

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u53d6\u6d88\u8ba2\u9605\u6240\u6709\u4ea7\u54c1\u670d\u52a1\u5305", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/packages/unsubscription"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> tenantUnsubscribeServicePackages(@PathVariable(value="tenantId") @Valid @Min(value=1L) @Valid @Min(value=1L) Long var1);

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5220\u9664\u4ea7\u54c1\u670d\u52a1\u5305", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/packages/delete"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> batchDetelecServicePackages(@PathVariable(value="tenantId") @Valid String var1, @RequestParam(name="byTenantCode", required=false) Boolean var2, @RequestBody @Valid TenantModel.Request.ServicePackageList var3);

    @ResponseBody
    @RequestMapping(name="\u53d8\u66f4\u79df\u6237\u670d\u52a1\u5305\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/packages/status"}, method={RequestMethod.PUT})
    public ResponseEntity<String> changeTenantServicePackageStatus(@PathVariable(value="tenantId") @Valid String var1, @RequestParam(name="byTenantCode", required=false) Boolean var2, @RequestBody @Valid TenantModel.Request.ChangePackageStatus var3);

    @ResponseBody
    @RequestMapping(name="\u67e5\u8be2\u79df\u6237\u670d\u52a1\u5305\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/packages/list"}, method={RequestMethod.GET})
    public <O extends TenantServicePackageDto> ResponseEntity<Page<TenantServicePackageDto>> getTenantPackageList(@SpringQueryMap TenantServiceRelModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u670d\u52a1\u5305\u8be6\u60c5", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{id}/packages/detail"}, method={RequestMethod.GET})
    public <O extends TenantServicePackageDto> ResponseEntity<TenantServicePackageDto> tenantServicePackageInfo(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) Long var1);

    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u79df\u6237\u7684\u670d\u52a1\u5305\u5217\u8868\u8be6\u60c5", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/packages/list"}, method={RequestMethod.GET})
    public <O extends TenantServicePackageDto> ResponseEntity<List<O>> getTenantServicePackageList(@PathVariable(value="tenantId") @Valid String var1, @SpringQueryMap TenantServiceRelModel.Request.Query var2, Pageable var3);

    @ResponseBody
    @RequestMapping(name="\u6839\u636e\u79df\u6237ID\u83b7\u53d6\u79df\u6237\u670d\u52a1\u5305\u76f8\u5173\u6240\u6709\u8d44\u6e90\u7801", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/resources"}, method={RequestMethod.GET})
    public <O extends ResourceDto> ResponseEntity<List<O>> getTenantResources(@PathVariable(value="tenantId") @Valid @Min(value=1L) @Valid @Min(value=1L) Long var1);

    public static interface Path
    extends Uri {
        public static final String TENANTS = "/tenants";
        public static final String TENANT_ID = "/tenants/{id}";
        public static final String UPDATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{id}";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{id}";
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants";
        public static final String LIST = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/list";
        public static final String CREATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants";
        public static final String EXISTS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/exists";
        public static final String SECRET = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{id}/secret";
        public static final String ALL_TENANT_SECRETS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/secrets";
        public static final String POLICY = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{id}/policy";
        public static final String PACKAGES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{id}/packages";
        public static final String BIND_COMPANIES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/companies/bind";
        public static final String BIND_COMPANY = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/company/bind/{companyId}";
        public static final String FIX_COMPANIES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/companies/fix";
        public static final String TENANT_RELATION_INFO = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/relation";
        public static final String CREATE_TENANT_RELATION = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/relation";
        public static final String DELETE_TENANT_RELATION = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/relation";
        public static final String HISTORIES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/histories";
        public static final String BIND_SERVICE_PACKAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/packages/bind";
        public static final String UNBIND_SERVICE_PACKAGES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/packages/unbind";
        public static final String UNSUBSCRIBE_SERVICE_PACKAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/packages/unsubscription";
        public static final String TENANT_SERVICE_PACKAGE_LIST = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/packages/list";
        public static final String DELETE_TENANT_SERVICE_PACKAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/packages/delete";
        public static final String CHANGE_TENANT_PACKAGE_SERVICE_STATUS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/packages/status";
        public static final String TENANT_SERVICE_PACKAGE_INFO = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{id}/packages/detail";
        public static final String TENANT_SERVICE_PACKAGE_ALL = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/packages/list";
        public static final String TENANT_SERVICE_RESOURCE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenants/{tenantId}/resources";
    }
}

