/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.tenant;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.TenantPolicyModel;
import com.xforceplus.domain.tenant.TenantPolicyDto;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface TenantPolicyApi {
    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7b56\u7565\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy"}, method={RequestMethod.GET})
    public <T extends TenantPolicyDto> ResponseEntity<Page<T>> page(@SpringQueryMap TenantPolicyModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u79df\u6237\u7b56\u7565", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy"}, method={RequestMethod.POST})
    public <T extends TenantPolicyDto> ResponseEntity<T> create(@RequestBody @Valid TenantPolicyModel.Request.Save var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u79df\u6237\u7b56\u7565", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy/{id}"}, method={RequestMethod.PUT})
    public <T extends TenantPolicyDto> ResponseEntity<T> update(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody @Valid TenantPolicyModel.Request.Update var3);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u79df\u6237\u7b56\u7565", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u79df\u6237\u5b89\u5168\u7b56\u7565", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/{tenantId}/tenant/policy"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteSecurityPolicy(@PathVariable(value="tenantId") @Valid @Min(value=1L) @Valid @Min(value=1L) Long var1);

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7b56\u7565\u8be6\u60c5", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy/{id}"}, method={RequestMethod.GET})
    public <T extends TenantPolicyDto> ResponseEntity<T> info(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(name="mergeSecurity", required=false) Boolean var3);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u79df\u6237\u5b89\u5168\u7b56\u7565", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/{tenantId}/policy/{policyId}/update"}, method={RequestMethod.PUT})
    public ResponseEntity<String> updateSecurityPolicy(@RequestBody List<TenantPolicyModel.Request.Update> var1);

    @ResponseBody
    @RequestMapping(name="\u521b\u5efa\u5e73\u53f0\u79df\u6237\u7b56\u7565", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy/default"}, method={RequestMethod.POST})
    public <T> ResponseEntity<TenantPolicyDto> createDefaultPolicy(@RequestBody @Valid TenantPolicyModel.Request.BaseSecurityModel<T> var1);

    @ResponseBody
    @RequestMapping(name="\u53d8\u66f4\u5e73\u53f0\u79df\u6237\u7b56\u7565\u542f\u7528\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy/{policyId}/status/{enabled}"}, method={RequestMethod.GET})
    public ResponseEntity<TenantPolicyDto> changePlatformPolicyStatus(@PathVariable(value="policyId") Long var1, @PathVariable(value="enabled") Boolean var2);

    @ResponseBody
    @RequestMapping(name="\u5355\u72ec\u66f4\u65b0\u79df\u6237\u5e73\u53f0\u7b56\u7565", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy/{policyId}/platform/update"}, method={RequestMethod.PUT})
    public <T> ResponseEntity<TenantPolicyDto> updatePlatformPolicy(@PathVariable(value="policyId") Long var1, @RequestBody TenantPolicyModel.Request.BaseSecurityModel<T> var2);

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u66f4\u65b0\u5e73\u53f0\u79df\u6237\u7b56\u7565", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy/platform/update/batch"}, method={RequestMethod.PUT})
    public <T> ResponseEntity<List<? extends TenantPolicyDto>> batchUpdateDefaultPolicy(@RequestBody @Valid List<TenantPolicyModel.Request.BaseSecurityModel<T>> var1);

    public static interface Path
    extends Uri {
        public static final String TENANT_POLICY = "/tenant/policy";
        public static final String POLICY_ID = "/tenant/policy/{id}";
        public static final String UPDATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy/{id}";
        public static final String DELETE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy/{id}";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy/{id}";
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy";
        public static final String CREATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy";
        public static final String CREATE_DEFAULT = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy/default";
        public static final String DELETE_SECURITY_POLICY = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/{tenantId}/tenant/policy";
        public static final String UPDATE_SECURITY_POLICY = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy/{policyId}/platform/update";
        public static final String UPDATE_TENANT_SECURITY_POLICY = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/{tenantId}/policy/{policyId}/update";
        public static final String CHANGE_DEFAULT_POLICY_STATUS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy/{policyId}/status/{enabled}";
        public static final String BATCH_UPDATE_PLATFORM_POLICY = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/tenant/policy/platform/update/batch";
    }
}

