/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.user;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.validation.ValidationGroup;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public interface PreRoleApi {
    @ResponseBody
    @RequestMapping(name="\u9884\u7f6e\u89d2\u8272\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/pre-roles"}, method={RequestMethod.GET})
    public <T extends RoleDto> ResponseEntity<Page<T>> page(@SpringQueryMap RoleModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u9884\u7f6e\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/pre-roles"}, method={RequestMethod.POST})
    public <T extends RoleDto> ResponseEntity<T> create(@RequestBody @Validated(value={ValidationGroup.OnCreate.class}) RoleModel.Request.Save var1);

    @ResponseBody
    @RequestMapping(name="\u4fee\u6539\u9884\u7f6e\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/pre-roles/{roleId}"}, method={RequestMethod.PUT})
    public <T extends RoleDto> ResponseEntity<T> update(@PathVariable(value="roleId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody @Validated(value={ValidationGroup.OnCreate.class}) RoleModel.Request.Save var3) throws Exception;

    @ResponseBody
    @RequestMapping(name="\u9884\u7f6e\u89d2\u8272\u542f\u7528", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/enable"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> enable(@PathVariable(value="roleId") @Valid @Min(value=1L) @Valid @Min(value=1L) Long var1) throws Throwable;

    @ResponseBody
    @RequestMapping(name="\u9884\u7f6e\u89d2\u8272\u7981\u7528", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/disable"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> disable(@PathVariable(value="roleId") @Valid @Min(value=1L) @Valid @Min(value=1L) Long var1) throws Throwable;

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u9884\u7f6e\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/pre-roles/{roleId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="roleId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1) throws Exception;

    @ResponseBody
    @RequestMapping(name="\u9884\u7f6e\u89d2\u8272\u8be6\u60c5", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/pre-roles/{roleId}"}, method={RequestMethod.GET})
    public <T extends RoleDto> ResponseEntity<T> info(@PathVariable(value="roleId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    public static interface Path
    extends Uri {
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/pre-roles";
        public static final String CREATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/pre-roles";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/pre-roles/{roleId}";
        public static final String INFO_BINDED = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/pre-roles/{roleId}/binded";
        public static final String UPDATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/pre-roles/{roleId}";
        public static final String DELETE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/pre-roles/{roleId}";
        public static final String ENABLE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/enable";
        public static final String DISABLE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/disable";
        public static final String UPDATE_STATUS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/pre-roles/{roleId}/{status}";
    }
}

