/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.user;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.domain.validation.ValidationGroup;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public interface RoleApi {
    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles"}, method={RequestMethod.GET})
    public <T extends RoleDto> ResponseEntity<Page<T>> page(@SpringQueryMap RoleModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles"}, method={RequestMethod.POST})
    public <T extends RoleDto> ResponseEntity<T> create(@RequestBody @Validated(value={ValidationGroup.OnCreate.class}) RoleModel.Request.Save var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}"}, method={RequestMethod.PUT})
    public <T extends RoleDto> ResponseEntity<T> update(@PathVariable(value="roleId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody @Validated(value={ValidationGroup.OnUpdate.class}) RoleModel.Request.Save var3);

    @ResponseBody
    @RequestMapping(name="\u4fee\u6539\u89d2\u8272\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="roleId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @PathVariable(value="status") @Valid @Range(min=0L, max=1L) @Valid @Range(min=0L, max=1L) int var3);

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}"}, method={RequestMethod.GET})
    public <T extends RoleDto> ResponseEntity<T> info(@PathVariable(value="roleId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="roleId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u7528\u6237\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/users"}, method={RequestMethod.GET})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<Page<U>> users(@PathVariable(value="roleId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, Pageable var3);

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u8d44\u6e90\u7801\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/resources"}, method={RequestMethod.GET})
    public <T extends ResourceDto> ResponseEntity<Page<T>> resources(@PathVariable(value="roleId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, Pageable var3);

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/users"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindUsers(@PathVariable(value="roleId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody RoleModel.Request.BindUsers var3);

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u529f\u80fd\u96c6", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/resource-sets"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindResourceSets(@PathVariable(value="roleId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody RoleModel.Request.BindResourceSets var3);

    public static interface Path
    extends Uri {
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles";
        public static final String LIST = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/list";
        public static final String CREATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles";
        public static final String UPDATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}";
        public static final String UPDATE_STATUS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/status/{status}";
        public static final String ENABLE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/enable";
        public static final String DISABLE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/disable";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}";
        public static final String DELETE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}";
        public static final String USERS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/users";
        public static final String RESOURCES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/resources";
        public static final String ROLE_BIND_USERS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/users";
        public static final String ROLE_BIND_RESOURCE_SETS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/resource-sets";
    }
}

