/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.user;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.domain.validation.ValidationGroup;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface UserApi {
    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users"}, method={RequestMethod.GET})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<Page<U>> page(@SpringQueryMap UserModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users"}, method={RequestMethod.POST})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> create(@RequestBody @Validated(value={ValidationGroup.OnCreate.class}) UserModel.Request.Save var1);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u5458\u5de5\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/simple"}, method={RequestMethod.POST})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> simpleCreate(@RequestBody @Validated(value={ValidationGroup.OnCreate.class}) UserModel.Request.SimpleSave var1);

    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}"}, method={RequestMethod.GET})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> info(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="loginId", required=false) String var3, @RequestParam(value="modules", required=false) String var4, @RequestParam(value="extraInfo", required=false, defaultValue="0") int var5);

    @ResponseBody
    @RequestMapping(name="\u6839\u636e\u7528\u6237\u540d\u83b7\u53d6\u7528\u6237\u8be6\u60c5", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/info"}, method={RequestMethod.GET})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> userInfo(@RequestParam(value="username", required=false) String var1, @RequestParam(value="tenantCode", required=false) String var2, @RequestParam(value="userCode", required=false) String var3, @RequestParam(value="extraInfo", required=false, defaultValue="0") int var4);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}"}, method={RequestMethod.PUT})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> update(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody UserModel.Request.Save var3);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u5458\u5de5\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/simple"}, method={RequestMethod.PUT})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> simpleUpdate(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody UserModel.Request.SimpleSave var3);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u7528\u6237\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/status/{status}"}, method={RequestMethod.POST})
    public ResponseEntity<String> updateStatus(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7684\u7ec4\u7ec7\u6811", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/orgs"}, method={RequestMethod.GET})
    public <O extends OrgDto<O>> ResponseEntity<O> userOrgs(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="modules", required=false) String var3);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7684\u8d44\u6e90\u7801\u96c6\u5408", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/resources"}, method={RequestMethod.GET})
    public ResponseEntity<Set<String>> userResources(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="loginId", required=false) String var3, @RequestParam(value="modules", required=false) String var4);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7684\u5e94\u7528\u8d44\u6e90\u7801\u96c6\u5408", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/app-resources"}, method={RequestMethod.GET})
    public ResponseEntity<Set<String>> appResources(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="appId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var3, @RequestParam(value="loginId", required=false) String var5, @RequestParam(value="modules", required=false) String var6);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7684\u591a\u4e2a\u5e94\u7528\u8d44\u6e90\u7801\u96c6\u5408", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/apps-resources"}, method={RequestMethod.GET})
    public ResponseEntity<Map<Long, Set<String>>> appsResources(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="appIds") String var3, @RequestParam(value="loginId", required=false) String var4, @RequestParam(value="modules", required=false) String var5);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ed1\u5b9a\u89d2\u8272\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/roles"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindRoles(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody UserModel.Request.BindRoles var3);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ed1\u5b9a\u89d2\u8272\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/roles"}, method={RequestMethod.POST})
    public ResponseEntity<List<UserModel.Request.BindRole>> bindUsersAndRoles(@RequestBody @Valid @Valid List<// Could not load outer class - annotation placement on inner may be incorrect
     @Valid UserModel.Request.BindRole> var1);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ed1\u5b9a\u7ec4\u7ec7\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/orgs"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindOrgs(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody UserModel.Request.BindOrgs var3);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ec4\u7ec7\u7ed1\u5b9a", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/user/org/bind"}, method={RequestMethod.POST})
    public ResponseEntity<List<UserModel.Request.BindOrg>> bindUserAndOrg(@RequestBody List<UserModel.Request.BindOrg> var1);

    @ResponseBody
    @RequestMapping(name="\u4e00\u7ad9\u5f0f\u5165\u4f4f\u6279\u91cf\u5f80\u7ec4\u7ec7\u5bfc\u5165\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/flow/{flow}/companies/{companyId}/tenant-service/users"}, method={RequestMethod.POST})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<UserModel.Response.BatchCreateResult<U, O, R, A>> batchCreateUser(@PathVariable(value="flow") String var1, @PathVariable(value="companyId") @Valid @Min(value=1L) @Valid @Min(value=1L) Long var2, @RequestBody @Valid @Valid List<// Could not load outer class - annotation placement on inner may be incorrect
     @Valid UserModel.Request.Save> var3);

    @ResponseBody
    @RequestMapping(name="\u5bfc\u51fa\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/export"}, method={RequestMethod.POST})
    public ResponseEntity<String> export(@RequestBody UserModel.Export var1);

    @ResponseBody
    @RequestMapping(name="\u67e5\u8be2\u7a0e\u53f7\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/tax-nums"}, method={RequestMethod.GET})
    public ResponseEntity<Set<String>> taxNums(@PathVariable(value="userId") Long var1, @RequestParam(value="loginId", required=false) String var2, @RequestParam(value="modules", required=false) String var3);

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u540c\u6b65\u7528\u6237\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/sync/batch"}, method={RequestMethod.POST})
    public ResponseEntity<List<UserModel.Response.BatchSyncResult>> batchSync(@RequestBody @Valid UserModel.Request.BatchSync var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u6362\u79df\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/tenants/{tenantId}/change"}, method={RequestMethod.GET})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> changeTenant(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) Long var1, @PathVariable(value="tenantId") @Valid @Min(value=1L) @Valid @Min(value=1L) Long var2);

    @ResponseBody
    @RequestMapping(name="\u6839\u636e\u5458\u5de5id\u83b7\u53d6\u516c\u53f8\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/companies"}, method={RequestMethod.GET})
    public <T extends CompanyDto> ResponseEntity<Set<T>> companies(@PathVariable(value="userId") Long var1, @RequestParam(value="loginId", required=false) String var2, @RequestParam(value="modules", required=false) String var3);

    @ResponseBody
    @RequestMapping(name="\u66f4\u6362\u79df\u6237\u7ba1\u7406\u5458", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{username}/tenants/{tenantId}/change/manager"}, method={RequestMethod.PUT})
    public ResponseEntity<String> changeTenantManager(@PathVariable(value="username") String var1, @PathVariable(value="tenantId") Long var2);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u767b\u51fa", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/logoff"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> logoff(@PathVariable(value="userId") Long var1, @RequestParam(value="loginId") String var2);

    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u6307\u5b9a\u7684usertag\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/tag"}, method={RequestMethod.GET})
    public ResponseEntity<String> userTag(@PathVariable(value="userId", required=true) Long var1, @RequestParam(value="tagName", required=true) String var2);

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u65b0\u589e\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/user-batch"}, method={RequestMethod.POST})
    public ResponseEntity<List<UserModel.Request.BatchSaveVo>> createBatch(@RequestBody List<UserModel.BatchSave> var1);

    public static interface Path
    extends Uri {
        public static final String API_PREFIX = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users";
        public static final String PAGE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users";
        public static final String LIST = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/list";
        public static final String CREATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users";
        public static final String SIMPLE_CREATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/simple";
        public static final String CREATE_BATCH = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/user-batch";
        public static final String UPDATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}";
        public static final String SIMPLE_UPDATE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/simple";
        public static final String UPDATE_STATUS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/status/{status}";
        public static final String INFO = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}";
        public static final String USER_INFO = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/info";
        public static final String DELETE = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}";
        public static final String ORGS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/orgs";
        public static final String RESOURCES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/resources";
        public static final String APP_RESOURCES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/app-resources";
        public static final String APPS_RESOURCES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/apps-resources";
        public static final String USER_ORG_BIND = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/user/org/bind";
        public static final String USERS_BIND_ROLES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/roles";
        public static final String USER_BIND_ROLES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/roles";
        public static final String USER_BIND_ORGS = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/orgs";
        public static final String BATCH_CREATE_USER = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/flow/{flow}/companies/{companyId}/tenant-service/users";
        public static final String EXPORT = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/export";
        public static final String LIST_TAX_NUM = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/tax-nums";
        public static final String LIST_COMPANIES = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/companies";
        public static final String BATCH_SYNC = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/sync/batch";
        public static final String CHANGE_TENANT = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/tenants/{tenantId}/change";
        public static final String CHANGE_TENANT_MANAGER = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{username}/tenants/{tenantId}/change/manager";
        public static final String LOGOFF = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/logoff";
        public static final String USER_TAG = "${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/tag";
    }
}

