/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.org;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.domain.company.CompanyTenantRelDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.domain.validation.ValidationGroup;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface OrgApi {
    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<Page<T>> page(@SpringQueryMap OrgModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs"}, method={RequestMethod.POST})
    public <T extends OrgDto<T>> ResponseEntity<T> create(@RequestBody @Validated(value={ValidationGroup.OnCreate.class}) OrgModel.Request.Save var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}"}, method={RequestMethod.PUT})
    public <T extends OrgDto<T>> ResponseEntity<T> update(@PathVariable(value="orgId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody OrgModel.Request.Save var3);

    @ResponseBody
    @RequestMapping(name="\u4fee\u6539\u7ec4\u7ec7\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="orgId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3);

    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<T> info(@PathVariable(value="orgId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="extraInfo", required=false, defaultValue="0") int var3);

    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u7528\u6237\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}/users"}, method={RequestMethod.GET})
    public <T extends UserDto<O, R>, O extends OrgDto<O>, R extends RoleDto> ResponseEntity<Page<T>> users(@PathVariable(value="orgId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, Pageable var3);

    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u5b50\u5b59", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}/descendants"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<List<T>> descendants(@PathVariable(value="orgId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u6811", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/tree"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<T> globalTree(@RequestParam(value="tenantId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u67e5\u8be2\u79df\u6237\u516c\u53f8\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/companies"}, method={RequestMethod.GET})
    public ResponseEntity<List<CompanyTenantRelDto>> companies(@SpringQueryMap OrgModel.Request.QueryForCms var1, @RequestParam(value="source") String var2);

    @ResponseBody
    @RequestMapping(name="\u6839\u636e\u7a0e\u53f7\u67e5\u8be2\u79df\u6237\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/by-taxnum"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<List<T>> byTaxNum(@RequestParam(value="taxNum") String var1, @RequestParam(value="companyId", required=false) Long var2, @RequestParam(value="tenantId", required=false) Long var3);

    public static interface Path
    extends Uri {
        public static final String page = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs";
        public static final String create = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs";
        public static final String update = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}";
        public static final String update_status = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}/status/{status}";
        public static final String info = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}";
        public static final String delete = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}";
        public static final String users = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}/users";
        public static final String descendants = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/{orgId}/descendants";
        public static final String tree = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/tree";
        public static final String companies = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/companies";
        public static final String by_taxNum = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/by-taxnum";
        public static final String list = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/orgs/list/company";
    }
}

