/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.account;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.AccountModel;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface AccountApi {
    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/login"}, method={RequestMethod.GET})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> login(@SpringQueryMap @Valid AccountModel.Request.Login var1, @RequestParam(value="extraInfo", required=false, defaultValue="0") int var2);

    @ResponseBody
    @RequestMapping(name="\u8d26\u6237\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts"}, method={RequestMethod.GET})
    public <A extends AccountDto> ResponseEntity<Page<A>> page(@SpringQueryMap AccountModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u8d26\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts"}, method={RequestMethod.POST})
    public <A extends AccountDto> ResponseEntity<A> create(@RequestBody @Valid AccountModel.Request.Create var1);

    @ResponseBody
    @RequestMapping(name="\u6ce8\u518c\u8d26\u53f7", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/register"}, method={RequestMethod.POST})
    public ResponseEntity<String> register(@RequestBody @Valid AccountModel.Request.Regist var1);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u8d26\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/batch"}, method={RequestMethod.POST})
    public <T extends AccountDto> ResponseEntity<List<T>> createBatch(@Valid @RequestBody @Valid List<// Could not load outer class - annotation placement on inner may be incorrect
     @Valid AccountModel.Request.Create> var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u8d26\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/{accountId}"}, method={RequestMethod.PUT})
    public <T extends AccountDto> ResponseEntity<T> update(@PathVariable(value="accountId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody @Valid AccountModel.Request.Update var3);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u8d26\u6237\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/{accountId}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="accountId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3);

    @ResponseBody
    @RequestMapping(name="\u6839\u636eid\u83b7\u53d6\u5e10\u53f7\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/{accountId}"}, method={RequestMethod.GET})
    public <T extends AccountDto> ResponseEntity<T> info(@PathVariable(value="accountId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u6539\u8d26\u6237\u5bc6\u7801", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/password"}, method={RequestMethod.PUT})
    public ResponseEntity<String> updatePassword(@RequestBody @Valid AccountModel.Request.ChangePassword var1);

    @ResponseBody
    @RequestMapping(name="\u9a8c\u8bc1\u5bc6\u7801", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/password"}, method={RequestMethod.GET})
    public ResponseEntity<String> checkPassword(@SpringQueryMap @Valid AccountModel.Request.CheckPassword var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u6362\u624b\u673a\u53f7\u53d1\u77ed\u4fe1", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/phone/code"}, method={RequestMethod.GET})
    public ResponseEntity<String> sendChangePhoneCode(@RequestParam(value="phone") String var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u6362\u90ae\u7bb1\u53d1\u77ed\u4fe1", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/email/code"}, method={RequestMethod.GET})
    public ResponseEntity<String> sendChangeEmailCode(@RequestParam(value="email") String var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u6362\u624b\u673a\u53f7", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/phone"}, method={RequestMethod.PUT})
    public ResponseEntity<String> changePhone(@RequestBody @Valid AccountModel.Request.ChangePhone var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u6362\u624b\u90ae\u7bb1", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/email"}, method={RequestMethod.PUT})
    public ResponseEntity<String> changeEmail(@RequestBody @Valid AccountModel.Request.ChangeEmail var1);

    public static interface Path
    extends Uri {
        public static final String page = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts";
        public static final String queryByUsername = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/username/{username}";
        public static final String create = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts";
        public static final String register = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/register";
        public static final String batchCreate = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/batch";
        public static final String update = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/{accountId}";
        public static final String update_status = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/{accountId}/status/{status}";
        public static final String login = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/login";
        public static final String info = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/{accountId}";
        public static final String delete = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/{accountId}";
        public static final String updatePassword = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/password";
        public static final String checkPassword = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/password";
        public static final String changePhone = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/phone";
        public static final String changeEmail = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/email";
        public static final String sendChangePhoneCode = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/phone/code";
        public static final String sendChangeEmailCode = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/accounts/email/code";
    }
}

