/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.tenant;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.TenantModel;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.resource.ServicePackageDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.domain.user.UserDto;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public interface TenantApi {
    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants"}, method={RequestMethod.GET})
    public <T extends TenantDto> ResponseEntity<Page<T>> page(@SpringQueryMap TenantModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u79df\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants"}, method={RequestMethod.POST})
    public <T extends TenantDto, O extends OrgDto<O>, C extends CompanyDto, U extends UserDto<O, R, A>, R extends RoleDto, A extends AccountDto> ResponseEntity<TenantModel.Response.CreateResult<T, O, C, U, R, A>> create(@RequestBody @Valid TenantModel.Request.Create var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u79df\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants/{id}"}, method={RequestMethod.PUT})
    public <T extends TenantDto> ResponseEntity<T> update(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody @Valid TenantModel.Request.Save var3);

    @ResponseBody
    @RequestMapping(name="\u67e5\u8be2\u79df\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants/{id}"}, method={RequestMethod.GET})
    public <T extends TenantDto> ResponseEntity<T> info(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u67e5\u8be2\u79df\u6237\u79c1\u94a5", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants/{id}/secret"}, method={RequestMethod.GET})
    public ResponseEntity<String> secret(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u79df\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7684\u516c\u53f8\u670d\u52a1\u5305\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants/{id}/packages"}, method={RequestMethod.GET})
    public <T extends ServicePackageDto> ResponseEntity<Page<T>> servicePackages(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, Pageable var3);

    @ResponseBody
    @RequestMapping(name="\u79df\u6237\u7ed1\u5b9a\u516c\u53f8", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants/{tenantId}/companies/bind"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindCompanies(@PathVariable(value="tenantId") long var1, @RequestBody List<Long> var3);

    public static interface Path
    extends Uri {
        public static final String page = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants";
        public static final String list = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants/list";
        public static final String create = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants";
        public static final String settle = "${xforce.tenant.service.url.prefix:}/{tenantCode}${xforce.tenant.service.version:}/settle";
        public static final String update = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants/{id}";
        public static final String secret = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants/{id}/secret";
        public static final String info = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants/{id}";
        public static final String delete = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants/{id}";
        public static final String packages = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants/{id}/packages";
        public static final String bindCompanies = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants/{tenantId}/companies/bind";
        public static final String fixCompanies = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/tenants/{tenantId}/companies/fix";
    }
}

