/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.resource;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.ResourcesetModel;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.domain.validation.ValidationGroup;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public interface ResourcesetApi {
    @ResponseBody
    @RequestMapping(name="\u529f\u80fd\u96c6\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/resourcesets"}, method={RequestMethod.GET})
    public <T extends ResourcesetDto> ResponseEntity<Page<T>> page(@SpringQueryMap ResourcesetModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u529f\u80fd\u96c6", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/resourcesets"}, method={RequestMethod.POST})
    public <T extends ResourcesetDto> ResponseEntity<T> create(@RequestBody @Validated(value={ValidationGroup.OnCreate.class}) ResourcesetModel.Request.Create var1);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u529f\u80fd\u96c6", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/resourcesets/{id}"}, method={RequestMethod.PUT})
    public <T extends ResourcesetDto> ResponseEntity<T> update(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody @Validated(value={ValidationGroup.OnUpdate.class}) ResourcesetModel.Request.Save var3);

    @ResponseBody
    @RequestMapping(name="\u4fee\u6539\u529f\u80fd\u96c6\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/resourcesets/{id}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> updateStatus(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3);

    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u529f\u80fd\u96c6\u8be6\u60c5", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/resourcesets/{id}"}, method={RequestMethod.GET})
    public <T extends ResourcesetDto> ResponseEntity<T> info(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u529f\u80fd\u96c6", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/resourcesets/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="id") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    public static interface Path
    extends Uri {
        public static final String page = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/resourcesets";
        public static final String list = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/resourcesets/list";
        public static final String create = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/resourcesets";
        public static final String update = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/resourcesets/{id}";
        public static final String update_status = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/resourcesets/{id}/status/{status}";
        public static final String info = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/resourcesets/{id}";
        public static final String delete = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/resourcesets/{id}";
    }
}

