/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.global.user;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.Range;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface UserApi {
    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users"}, method={RequestMethod.GET})
    public <T extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<Page<T>> page(@SpringQueryMap UserModel.Request.Query var1, Pageable var2);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users"}, method={RequestMethod.POST})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> create(@RequestBody @Valid UserModel.Request.Create var1);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/user-batch"}, method={RequestMethod.POST})
    public ResponseEntity<List<UserModel.Request.BatchSaveVo>> createBatch(@RequestBody List<UserModel.Request.BatchSave> var1);

    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}"}, method={RequestMethod.GET})
    public <T extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<T> info(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="extraInfo", required=false, defaultValue="0") int var3);

    @ResponseBody
    @RequestMapping(name="\u6839\u636e\u7528\u6237\u540d\u83b7\u53d6\u7528\u6237\u8be6\u60c5", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/info"}, method={RequestMethod.GET})
    public <T extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<T> user_info(@RequestParam(value="username", required=false) String var1, @RequestParam(value="tenantCode", required=false) String var2, @RequestParam(value="userCode", required=false) String var3, @RequestParam(value="extraInfo", required=false, defaultValue="0") int var4);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}"}, method={RequestMethod.PUT})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> update(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody UserModel.Request.Update var3);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u7528\u6237\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/status/{status}"}, method={RequestMethod.POST})
    public ResponseEntity<String> updateStatus(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @PathVariable(value="status") @Valid @Range(max=1L) @Valid @Range(max=1L) int var3);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7684\u7ec4\u7ec7\u6811", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/orgs"}, method={RequestMethod.GET})
    public <T extends OrgDto<T>> ResponseEntity<T> userOrgs(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7684\u8d44\u6e90\u7801\u96c6\u5408", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/resources"}, method={RequestMethod.GET})
    public ResponseEntity<Set<String>> userResources(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="loginId", required=false) String var3);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7684\u5e94\u7528\u8d44\u6e90\u7801\u96c6\u5408", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/app-resources"}, method={RequestMethod.GET})
    public ResponseEntity<Set<String>> appResources(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestParam(value="appId") long var3, @RequestParam(value="loginId", required=false) String var5);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ed1\u5b9a\u89d2\u8272\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/roles"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindRoles(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody UserModel.Request.BindRoles var3);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ed1\u5b9a\u89d2\u8272\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/roles"}, method={RequestMethod.POST})
    public <T extends UserModel.Request.BindRole> ResponseEntity<List<T>> bindUsersAndRoles(@RequestBody @Valid @Valid List<// Could not load outer class - annotation placement on inner may be incorrect
     @Valid UserModel.Request.BindRole> var1);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ed1\u5b9a\u7ec4\u7ec7\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/orgs"}, method={RequestMethod.POST})
    public ResponseEntity<String> bindOrgs(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @RequestBody UserModel.Request.BindOrgs var3);

    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u7ec4\u7ec7\u7ed1\u5b9a", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/user/org/bind"}, method={RequestMethod.POST})
    public ResponseEntity<List<UserModel.Request.BindOrg>> bindUserAndOrg(@RequestBody List<UserModel.Request.BindOrg> var1);

    @ResponseBody
    @RequestMapping(name="\u68c0\u67e5\u7528\u6237\u662f\u5426\u6709\u63a5\u53e3\u8bbf\u95ee\u6743\u9650", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/check-uri-authz"}, method={RequestMethod.GET})
    public ResponseEntity<Boolean> checkUriAuthz(@PathVariable(value="userId") @Valid @Min(value=1L) @Valid @Min(value=1L) long var1, @SpringQueryMap @Valid UserModel.Request.CheckUriAuthzQuery var3);

    @ResponseBody
    @RequestMapping(name="\u4e00\u7ad9\u5f0f\u5165\u4f4f\u6279\u91cf\u5f80\u7ec4\u7ec7\u5bfc\u5165\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/flow/{flow}/companies/{companyId}/tenant-service/users"}, method={RequestMethod.POST})
    public <O extends OrgDto<O>, U extends UserDto<O, R, A>, R extends RoleDto, A extends AccountDto> ResponseEntity<UserModel.Request.SaveUserOutput<U, O, R, A>> batchCreateUser(@PathVariable(value="flow") @Valid String var1, @PathVariable(value="companyId") @Valid @Min(value=1L) @Valid @Min(value=1L) Long var2, @RequestBody @Valid List<UserModel.Request.Create> var3);

    @ResponseBody
    @RequestMapping(name="\u5bfc\u51fa\u7528\u6237", value={"${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/export"}, method={RequestMethod.POST})
    public ResponseEntity<String> export(@RequestBody UserModel.Export var1);

    public static interface Path
    extends Uri {
        public static final String page = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users";
        public static final String list = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/list";
        public static final String create = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users";
        public static final String createBatch = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/user-batch";
        public static final String update = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}";
        public static final String update_status = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/status/{status}";
        public static final String info = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}";
        public static final String user_info = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/info";
        public static final String delete = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}";
        public static final String orgs = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/orgs";
        public static final String resources = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/resources";
        public static final String appResources = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/app-resources";
        public static final String userOrgBind = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/user/org/bind";
        public static final String users_bind_roles = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/roles";
        public static final String user_bind_roles = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/roles";
        public static final String user_bind_orgs = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/orgs";
        public static final String check_uri_authz = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/{userId}/check-uri-authz";
        public static final String batchCreateUser = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/flow/{flow}/companies/{companyId}/tenant-service/users";
        public static final String export = "${xforce.tenant.service.url.prefix:}/global${xforce.tenant.service.version:}/users/export";
    }
}

