/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.api.tenant.user;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseBoolenEntity;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import java.util.List;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public interface RoleApi {
    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles"}, method={RequestMethod.GET})
    public <T extends RoleDto> ResponseEntity<Page<T>> page(@PathVariable(value="tenantId") long var1, @SpringQueryMap RoleModel.Request.Query var3, Pageable var4);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles"}, method={RequestMethod.POST})
    public <T extends RoleDto> ResponseEntity<T> create(@PathVariable(value="tenantId") long var1, @RequestBody RoleModel.Request.Save var3);

    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/batch"}, method={RequestMethod.POST})
    public <T> ResponseEntity<T> batchCreate(@PathVariable(value="tenantId") long var1, @RequestBody List<RoleModel.Request.Save> var3);

    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u7ed1\u5b9a\u529f\u80fd\u96c6\u5408", value={"${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/resource-sets"}, method={RequestMethod.POST})
    public <T, V extends RoleModel.Request.BindResourceSet> ResponseBoolenEntity<Boolean, RoleModel.Request.BindResourceSet> bindResourceSets(@PathVariable(value="tenantId") long var1, @RequestBody List<RoleModel.Request.BindResourceSet> var3);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/{roleId}"}, method={RequestMethod.PUT})
    public <T extends RoleDto> ResponseEntity<T> update(@PathVariable(value="tenantId") long var1, @PathVariable(value="roleId") long var3, @RequestBody RoleModel.Request.Save var5);

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u89d2\u8272\u72b6\u6001", value={"${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/{roleId}/status/{status}"}, method={RequestMethod.PATCH})
    public ResponseEntity<String> update_status(@PathVariable(value="tenantId") long var1, @PathVariable(value="roleId") long var3, @PathVariable(value="status") int var5);

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u4fe1\u606f", value={"${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/{roleId}"}, method={RequestMethod.GET})
    public <T extends RoleDto> ResponseEntity<T> info(@PathVariable(value="tenantId") long var1, @PathVariable(value="roleId") long var3);

    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/{roleId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="tenantId") long var1, @PathVariable(value="roleId") long var3);

    @ResponseBody
    @RequestMapping(name="\u89d2\u8272\u7528\u6237\u5217\u8868", value={"${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/{roleId}/users"}, method={RequestMethod.GET})
    public <T extends UserDto<O, R>, O extends OrgDto<O>, R extends RoleDto> ResponseEntity<Page<T>> users(@PathVariable(value="tenantId") long var1, @PathVariable(value="roleId") long var3, Pageable var5);

    public static interface Path
    extends Uri {
        public static final String page = "${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles";
        public static final String list = "${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/list";
        public static final String create = "${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles";
        public static final String batchCreate = "${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/batch";
        public static final String update = "${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/{roleId}";
        public static final String update_status = "${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/{roleId}/status/{status}";
        public static final String info = "${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/{roleId}";
        public static final String delete = "${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/{roleId}";
        public static final String users = "${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/{roleId}/users";
        public static final String bindResourceSet = "${xforce.tenant.service.url.prefix:}/{tenantId}${xforce.tenant.service.version:}/roles/resource-sets";
    }
}

