package com.xforceplus.api.tenant.org.virtual;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.OrgVirtualModel;
import com.xforceplus.api.model.TreeModel;
import com.xforceplus.domain.orgVirtual.OrgVirtualDTO;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import java.util.List;

@SuppressWarnings("all")
public interface OrgVirtualApi {

    @ResponseBody
    @RequestMapping(name = "根据用户id查询组织（返回当前节点与子节点）", value = Path.LIST_BY_USERID, method = RequestMethod.GET)
    ResponseEntity<List<OrgVirtualModel.Response.Model>> listByUserId(@PathVariable("tenantKey") String tenantKey,
                                                                      @PathVariable(value = "typeId") Long typeId,
                                                                      @PathVariable(value = "userId") @Valid @Min(1) Long userId,
                                                                      @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode);

    @ResponseBody
    @RequestMapping(name = "根据节点id查询组织（返回当前节点与子节点-列表）", value = Path.LIST_BY_NODEID, method = RequestMethod.GET)
    ResponseEntity<List<OrgVirtualModel.Response.Model>> listByNodeId(@PathVariable("tenantKey") String tenantKey,
                                                                      @PathVariable(value = "nodeId") @Valid @Min(1) Long nodeId,
                                                                      @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                                      @RequestParam(value = "scope", required = false) TreeModel.Scope scope);

    @ResponseBody
    @RequestMapping(name = "根据节点id查询组织（返回当前节点与子节点-tree）", value = Path.TREE_BY_NODEID, method = RequestMethod.GET)
    ResponseEntity<OrgVirtualModel.Response.Model> treeByNodeId(@PathVariable("tenantKey") String tenantKey,
                                                                @PathVariable(value = "nodeId") @Valid @Min(1) Long nodeId,
                                                                @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                                @RequestParam(value = "scope", required = false) TreeModel.Scope scope);

    @ResponseBody
    @RequestMapping(name = "根据ids/code查询(虚拟)组织（返回ids/codes对应分组）", value = Path.LIST_BY_NODE_KEYS, method = RequestMethod.GET)
    ResponseEntity<List<OrgVirtualModel.Response.Model>> listByKeys(@PathVariable("tenantKey") String tenantKey,
                                                                    @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                                    @RequestParam(value = "scope") TreeModel.Scope scope,
                                                                    @RequestParam(value = "nodeTypeId") Integer nodeTypeId,
                                                                    @RequestParam(value = "byId", required = false, defaultValue = "true") boolean byId,
                                                                    @RequestParam(value = "orgVirtualKeys") String orgVirtualKeys);

    @ResponseBody
    @RequestMapping(name = "当前租户下新建虚拟组织", value = Path.CREATE, method = RequestMethod.POST)
    <O extends OrgVirtualDTO> ResponseEntity<O> tenantCreate(@PathVariable("tenantKey") String tenantKey,
                                                             @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                             @RequestBody @Valid OrgVirtualModel.Request.Create model);


    @ResponseBody
    @RequestMapping(name = "当前租户下的虚拟组织", value = Path.PAGE, method = RequestMethod.GET)
    <O extends OrgVirtualDTO> ResponseEntity<Page<O>> tenantPage(@PathVariable("tenantKey") String tenantKey,
                                                                 @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                                 @SpringQueryMap OrgVirtualModel.Request.Query query,
                                                                 Pageable pageable);

    @ResponseBody
    @RequestMapping(name = "更新租户下虚拟组织", value = Path.UPDATE, method = RequestMethod.PUT)
    <O extends OrgVirtualDTO> ResponseEntity<O> tenantUpdate(@PathVariable("tenantKey") String tenantKey,
                                                             @RequestParam(value = "byTenantCode", required = false) Boolean byTenantCode,
                                                             @PathVariable("id") @Valid @Min(1) Long orgVirtualId,
                                                             @RequestBody @Valid OrgVirtualModel.Request.Update model);

    interface Path extends Uri {

        String CUSTOM_PATH_PREFIX = Uri.PATH_PREFIX + "/{tenantKey}" + Uri.API_VERSION;

        String LIST_BY_USERID = CUSTOM_PATH_PREFIX + "/org-virtuals/{typeId}/user/{userId}";
        String LIST_BY_NODEID = CUSTOM_PATH_PREFIX + "/org-virtuals/list/node/{nodeId}";
        String LIST_BY_NODE_KEYS = CUSTOM_PATH_PREFIX + "/org-virtuals/list/node/keys";
        String TREE_BY_NODEID = CUSTOM_PATH_PREFIX + "/org-virtuals/tree/node/{nodeId}";
        String CREATE = CUSTOM_PATH_PREFIX + "/org-virtuals";
        String PAGE = CUSTOM_PATH_PREFIX + "/org-virtuals";
        String UPDATE = CUSTOM_PATH_PREFIX + "/org-virtuals/{id}";


    }
}
